/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.contentprovider.di.internal;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.sasheditor.contentprovider.di.internal.DiContentProvider;

public class TransactionalDiContentProvider
implements ISashWindowsContentProvider {
    private DiContentProvider diContentProvider;
    private TransactionalEditingDomain editingDomain;

    public TransactionalDiContentProvider(DiContentProvider diContentProvider, TransactionalEditingDomain editingDomain) {
        this.diContentProvider = diContentProvider;
        this.editingDomain = editingDomain;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    public void addPage(final Object page) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.addPage(page);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void addPage(final Object page, final int index) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.addPage(page, index);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public IAbstractPanelModel createChildSashModel(Object root) {
        return this.diContentProvider.createChildSashModel(root);
    }

    public void createFolder(final ITabFolderModel tabFolder, final int tabIndex, final ITabFolderModel targetFolder, final int side) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.createFolder(tabFolder, tabIndex, targetFolder, side);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void setCurrentFolder(final Object rawModel) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.setCurrentFolder(rawModel);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public Object getRootModel() {
        return this.diContentProvider.getRootModel();
    }

    public void movePage(final ITabFolderModel folderModel, final int oldIndex, final int newIndex) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.movePage(folderModel, oldIndex, newIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void movePage(final ITabFolderModel srcFolderModel, final int sourceIndex, final ITabFolderModel targetFolderModel, final int targetIndex) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.movePage(srcFolderModel, sourceIndex, targetFolderModel, targetIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void removePage(final int index) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.removePage(index);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void removePage(final Object page) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.removePage(page);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    public void removePage(final ITabFolderModel parentFolder, final int tabIndex) {
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                TransactionalDiContentProvider.this.diContentProvider.removePage(parentFolder, tabIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }
}

