/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.contentprovider.di.internal;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.di.internal.PageMngrImpl;
import org.eclipse.papyrus.sasheditor.editor.IPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalPageMngrImpl
implements IPageMngr {
    private PageMngrImpl pageMngr;
    private TransactionalEditingDomain editingDomain;

    public TransactionalPageMngrImpl(PageMngrImpl pageMngr, TransactionalEditingDomain editingDomain) {
        this.pageMngr = pageMngr;
        this.editingDomain = editingDomain;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    public void addPage(final Object pageIdentifier) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.addPage(pageIdentifier);
            }
        }.run();
    }

    public List<Object> allPages() {
        return this.pageMngr.allPages();
    }

    public void closePage(final Object pageIdentifier) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.closePage(pageIdentifier);
            }
        }.run();
    }

    public void closeAllOpenedPages() {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.closeAllOpenedPages();
            }
        }.run();
    }

    public void closeOtherPages(final Object pageIdentifier) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.closeOtherPages(pageIdentifier);
            }
        }.run();
    }

    public void openPage(final Object pageIdentifier) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.openPage(pageIdentifier);
            }
        }.run();
    }

    public void removePage(final Object pageIdentifier) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.removePage(pageIdentifier);
            }
        }.run();
    }

    public boolean isOpen(Object pageIdentifier) {
        return this.pageMngr.isOpen(pageIdentifier);
    }

    public void openPrevious() {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.openPrevious();
            }
        }.run();
    }

    public void openNext() {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.openNext();
            }
        }.run();
    }

    public void pageChanged(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageChanged(page);
            }
        }.run();
    }

    public void pageOpened(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageOpened(page);
            }
        }.run();
    }

    public void pageClosed(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageClosed(page);
            }
        }.run();
    }

    public void pageActivated(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageActivated(page);
            }
        }.run();
    }

    public void pageDeactivated(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageDeactivated(page);
            }
        }.run();
    }

    public void pageAboutToBeOpened(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageAboutToBeOpened(page);
            }
        }.run();
    }

    public void pageAboutToBeClosed(final IPage page) {
        new TransactionPageMngrRunnable(){

            public void doRun() {
                TransactionalPageMngrImpl.this.pageMngr.pageAboutToBeClosed(page);
            }
        }.run();
    }

    public boolean hasPreviousHistory() {
        return this.pageMngr.hasPreviousHistory();
    }

    public boolean hasNextHistory() {
        return this.pageMngr.hasNextHistory();
    }

    public int isInHsitory(Object pageIdentifier) {
        return this.pageMngr.isInHsitory(pageIdentifier);
    }

    public abstract class TransactionPageMngrRunnable
    implements Runnable {
        public void run() {
            TransactionalEditingDomain editingDomain = TransactionalPageMngrImpl.this.getTransactionalEditingDomain();
            RecordingCommand command = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    TransactionPageMngrRunnable.this.doRun();
                }
            };
            editingDomain.getCommandStack().execute((Command)command);
        }

        public abstract void doRun();
    }
}

