/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sashwindows.di.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.sashwindows.di.AbstractPanel;
import org.eclipse.papyrus.sashwindows.di.DiPackage;
import org.eclipse.papyrus.sashwindows.di.PanelParent;
import org.eclipse.papyrus.sashwindows.di.SashPanel;
import org.eclipse.papyrus.sashwindows.di.impl.AbstractPanelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashPanelImpl
extends AbstractPanelImpl
implements SashPanel {
    protected EList<AbstractPanel> children;
    protected static final float SASH_POSITION_EDEFAULT = 0.0f;
    protected float sashPosition = 0.0f;
    protected static final int DIRECTION_EDEFAULT = 0;
    protected int direction = 0;

    protected SashPanelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DiPackage.Literals.SASH_PANEL;
    }

    @Override
    public EList<AbstractPanel> getChildren() {
        if (this.children == null) {
            this.children = new EObjectContainmentWithInverseEList(AbstractPanel.class, (InternalEObject)this, 1, 0);
        }
        return this.children;
    }

    @Override
    public float getSashPosition() {
        return this.sashPosition;
    }

    @Override
    public void setSashPosition(float newSashPosition) {
        float oldSashPosition = this.sashPosition;
        this.sashPosition = newSashPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldSashPosition, this.sashPosition));
        }
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(int newDirection) {
        int oldDirection = this.direction;
        this.direction = newDirection;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldDirection, this.direction));
        }
    }

    @Override
    public void setChildren(AbstractPanel leftChild, AbstractPanel rightChild, int direction) {
        this.setDirection(direction);
        EList<AbstractPanel> children = this.getChildren();
        if (children.size() == 0) {
            children.add(leftChild);
            children.add(rightChild);
        } else {
            children.set(0, leftChild);
            children.set(1, rightChild);
        }
    }

    @Override
    public void delete(AbstractPanel childToDelete) {
        EList<AbstractPanel> children = this.getChildren();
        AbstractPanel otherChild = childToDelete == children.get(0) ? (AbstractPanel)children.get(1) : (AbstractPanel)children.get(0);
        PanelParent parent = this.getParent();
        parent.replaceChild(this, otherChild);
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getChildren()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getChildren();
            }
            case 2: {
                return Float.valueOf(this.getSashPosition());
            }
            case 3: {
                return this.getDirection();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setSashPosition(((Float)newValue).floatValue());
                return;
            }
            case 3: {
                this.setDirection((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getChildren().clear();
                return;
            }
            case 2: {
                this.setSashPosition(0.0f);
                return;
            }
            case 3: {
                this.setDirection(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.children != null && !this.children.isEmpty();
            }
            case 2: {
                return this.sashPosition != 0.0f;
            }
            case 3: {
                return this.direction != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == PanelParent.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == PanelParent.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sashPosition: ");
        result.append(this.sashPosition);
        result.append(", direction: ");
        result.append(this.direction);
        result.append(')');
        return result.toString();
    }

    @Override
    public void replaceChild(AbstractPanel oldChild, AbstractPanel newChild) {
        int index = this.getChildren().indexOf((Object)oldChild);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Child '" + oldChild + "' not found in sash. Can't replace it.");
        }
        this.getChildren().set(index, (Object)newChild);
        newChild.setParent(this);
    }
}

