/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.contentprovider.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.sasheditor.contentprovider.simple.AbstractPanelModel;
import org.eclipse.papyrus.sasheditor.contentprovider.simple.SimpleSashWindowsContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFolderModel
extends AbstractPanelModel
implements ITabFolderModel {
    private List<IPageModel> children = new ArrayList<IPageModel>();
    private SimpleSashWindowsContentProvider contentProvider;

    public TabFolderModel(SimpleSashWindowsContentProvider contentProvider) {
        super(null);
        this.contentProvider = contentProvider;
    }

    @Override
    public List<?> getChildren() {
        return this.children;
    }

    @Override
    public IPageModel createChildSashModel(Object child) {
        return (IPageModel)child;
    }

    private void addItem(IPageModel newModel) {
        this.doAddItem(newModel);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, newModel));
    }

    private void addItem(int index, IPageModel newModel) {
        this.doAddItem(index, newModel);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, newModel));
    }

    public IPageModel removeTab(int index) {
        IPageModel removed = this.doRemoveTab(index);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(1, this, removed));
        return removed;
    }

    public void removeTab(IPageModel tabItem) {
        this.doRemoveTab(tabItem);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, tabItem));
    }

    public void moveTab(int oldIndex, int newIndex) {
        int listSize = this.children.size();
        if (newIndex >= listSize) {
            newIndex = listSize - 1;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (oldIndex == newIndex) {
            return;
        }
        if (listSize == 0) {
            return;
        }
        IPageModel toMove = this.children.remove(oldIndex);
        this.children.add(newIndex, toMove);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(3, this, toMove));
    }

    protected void doAddItem(IPageModel newModel) {
        this.children.add(newModel);
    }

    protected void doAddItem(int index, IPageModel newModel) {
        if (index > this.children.size() || index < 0) {
            this.children.add(newModel);
        } else {
            this.children.add(index, newModel);
        }
    }

    protected IPageModel doRemoveTab(int index) {
        IPageModel removed = this.children.remove(index);
        return removed;
    }

    protected List<IPageModel> doRemoveAll() {
        ArrayList<IPageModel> removed = new ArrayList<IPageModel>(this.children);
        this.children.clear();
        return removed;
    }

    protected void doAddAllTab(List<IPageModel> newTabs) {
        this.children.addAll(newTabs);
    }

    protected void doRemoveTab(IPageModel tabItem) {
        this.children.remove(tabItem);
        this.contentProvider.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, tabItem));
    }

    @Override
    public void replaceChild(AbstractPanelModel oldChild, AbstractPanelModel newChild) {
        throw new UnsupportedOperationException("This method should not be called on this class.");
    }

    @Override
    protected TabFolderModel lookupTabFolder(IPageModel tabItem) {
        if (tabItem == null) {
            return this;
        }
        if (this.children.contains(tabItem)) {
            return this;
        }
        return null;
    }
}

