/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.editor;

import java.util.logging.Logger;
import org.eclipse.papyrus.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.sasheditor.editor.IPage;
import org.eclipse.papyrus.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.sasheditor.editor.SashContainerEventsListener;
import org.eclipse.papyrus.sasheditor.editor.SashWindowsContainer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;

public class SashTabDecorationSynchronizer {
    Logger log = Logger.getLogger(this.getClass().getName());
    private SashWindowsContainer container;
    SashContainerEventsListener pageLifeCycleListener = new SashContainerEventsListener(){

        public void pageChanged(IPage newPage) {
        }

        public void pageOpened(IPage page) {
            SashTabDecorationSynchronizer.this.attachPage(page);
        }

        public void pageDeactivated(IPage page) {
        }

        public void pageClosed(IPage page) {
            SashTabDecorationSynchronizer.this.detachPage(page);
        }

        public void pageActivated(IPage page) {
        }

        public void pageAboutToBeOpened(IPage page) {
        }

        public void pageAboutToBeClosed(IPage page) {
        }
    };
    private IPropertyListener editorPartPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1 && source instanceof IEditorPart) {
                SashTabDecorationSynchronizer.this.refreshContainerTabForPage((IEditorPart)source);
            }
        }
    };

    public SashTabDecorationSynchronizer(SashWindowsContainer container) {
        this.container = container;
        this.attachContainerPages();
        this.attachListeners();
    }

    public void dispose() {
        this.detachListeners();
        this.detachContainerPages();
    }

    protected void attachListeners() {
        this.container.addLifeCycleListener(this.pageLifeCycleListener);
    }

    protected void detachListeners() {
        this.container.removeLifeCycleListener(this.pageLifeCycleListener);
    }

    protected void attachPage(IPage page) {
        if (page instanceof IEditorPage) {
            this.log.fine("attachPage( " + page + " )");
            IEditorPage editorPage = (IEditorPage)page;
            editorPage.getIEditorPart().addPropertyListener(this.editorPartPropertyListener);
        }
    }

    protected void detachPage(IPage page) {
        if (page instanceof IEditorPage) {
            this.log.fine("attachPage( " + page + " )");
            IEditorPage editorPage = (IEditorPage)page;
            editorPage.getIEditorPart().removePropertyListener(this.editorPartPropertyListener);
        }
    }

    protected void refreshContainerTabForPage(IEditorPart source) {
        IPage page = this.container.lookupIPageByIEditorPart(source);
        this.refreshContainerTabForPage(page);
    }

    protected void refreshContainerTabForPage(IPage page) {
        this.container.refreshPageTab(page);
    }

    private void detachContainerPages() {
        this.container.visit(new DetachVisitor());
    }

    private void attachContainerPages() {
        this.container.visit(new AttachVisitor());
    }

    private class AttachVisitor
    implements IPageVisitor {
        private AttachVisitor() {
        }

        public void accept(IComponentPage page) {
        }

        public void accept(IEditorPage page) {
            SashTabDecorationSynchronizer.this.attachPage(page);
        }
    }

    private class DetachVisitor
    implements IPageVisitor {
        private DetachVisitor() {
        }

        public void accept(IComponentPage page) {
        }

        public void accept(IEditorPage page) {
            SashTabDecorationSynchronizer.this.detachPage(page);
        }
    }
}

