/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.sasheditor.internal.AbstractPanelPart;
import org.eclipse.papyrus.sasheditor.internal.PagePart;

public class PartLists {
    private List<PagePart> pageParts = new ArrayList<PagePart>();
    private List<AbstractPanelPart> panelParts = new ArrayList<AbstractPanelPart>();
    private List<PagePart> createdPages;

    public PagePart findPagePartFor(Object rawModel) {
        for (PagePart part : this.pageParts) {
            if (!part.isPartFor(rawModel)) continue;
            return part;
        }
        return null;
    }

    public AbstractPanelPart findPartFor(Object rawModel) {
        for (AbstractPanelPart part : this.panelParts) {
            if (!part.isPartFor(rawModel)) continue;
            return part;
        }
        return null;
    }

    public void addLeaf(PagePart pagePart) {
        this.pageParts.add(pagePart);
    }

    public void addPart(AbstractPanelPart panelPart) {
        this.panelParts.add(panelPart);
    }

    public void garbage() {
        for (AbstractPanelPart abstractPanelPart : this.panelParts) {
            if (!abstractPanelPart.isOrphaned()) continue;
            abstractPanelPart.dispose();
        }
        for (PagePart pagePart : this.pageParts) {
            if (!pagePart.isOrphaned()) continue;
            pagePart.garbage();
        }
    }

    public PagePart getFirstValidPage() {
        for (PagePart part : this.pageParts) {
            if (part.isOrphaned()) continue;
            return part;
        }
        return null;
    }

    public PagePart getFirstCreatedPage() {
        if (this.createdPages == null) {
            return null;
        }
        if (this.createdPages.size() > 0) {
            return this.createdPages.get(0);
        }
        return null;
    }

    public void addCreatedPage(PagePart newPage) {
        if (this.createdPages == null) {
            this.createdPages = new ArrayList<PagePart>();
        }
        this.createdPages.add(newPage);
    }
}

