/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.sasheditor.editor.SashContainerEventsListener;
import org.eclipse.papyrus.sasheditor.internal.PagePart;

public class SashContainerEventsProvider {
    private List<SashContainerEventsListener> listeners = new ArrayList<SashContainerEventsListener>();

    public void addListener(SashContainerEventsListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(SashContainerEventsListener listener) {
        this.listeners.remove(listener);
    }

    public void firePageOpenedEvent(PagePart page) {
        for (SashContainerEventsListener listener : this.listeners) {
            listener.pageOpened(page);
        }
    }

    public void firePageClosedEvent(PagePart page) {
        for (SashContainerEventsListener listener : this.listeners) {
            listener.pageClosed(page);
        }
    }

    public void firePageAboutToBeOpenedEvent(PagePart page) {
        for (SashContainerEventsListener listener : this.listeners) {
            listener.pageAboutToBeOpened(page);
        }
    }

    public void firePageAboutToBeClosedEvent(PagePart page) {
        for (SashContainerEventsListener listener : this.listeners) {
            listener.pageAboutToBeClosed(page);
        }
    }

    public void firePageActivatedEvent(PagePart page) {
        for (SashContainerEventsListener listener : this.listeners) {
            listener.pageActivated(page);
        }
    }

    public void firePageDeactivatedEvent(PagePart page) {
        for (SashContainerEventsListener listener : this.listeners) {
            listener.pageDeactivated(page);
        }
    }
}

