/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.internal;

import java.util.logging.Logger;
import org.eclipse.papyrus.sasheditor.Activator;
import org.eclipse.papyrus.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.sasheditor.contentprovider.ISashPanelModel;
import org.eclipse.papyrus.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.sasheditor.internal.AbstractPanelPart;
import org.eclipse.papyrus.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.sasheditor.internal.IPanelParent;
import org.eclipse.papyrus.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.sasheditor.internal.NotFoundException;
import org.eclipse.papyrus.sasheditor.internal.PartLists;
import org.eclipse.papyrus.sasheditor.internal.ReplaceableSashForm;
import org.eclipse.papyrus.sasheditor.internal.TabFolderPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDropTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashPanelPart
extends AbstractPanelPart
implements IPanelParent {
    Logger log = Logger.getLogger(this.getClass().getName());
    protected ISashPanelModel model;
    private Object rawModel;
    protected AbstractPanelPart[] currentChildParts = new AbstractPanelPart[2];
    private ReplaceableSashForm container;
    private int sashDirection = 256;

    public SashPanelPart(IPanelParent parent, ISashPanelModel model, Object rawModel) {
        super(parent);
        this.model = model;
        this.rawModel = rawModel;
        this.sashDirection = model.getSashDirection();
    }

    public ISashPanelModel getPartModel() {
        return this.model;
    }

    @Override
    public void fillPartMap(PartLists partMap) {
        partMap.addPart(this);
        AbstractPanelPart[] abstractPanelPartArray = this.currentChildParts;
        int n = this.currentChildParts.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPanelPart child = abstractPanelPartArray[n2];
            child.fillPartMap(partMap);
            ++n2;
        }
        this.garbageState = AbstractPart.GarbageState.UNVISITED;
    }

    @Override
    public void createPartControl(Composite parent) {
        this.createControl(parent);
    }

    protected void createControl(Composite parent) {
        this.container = new ReplaceableSashForm(parent, this.sashDirection);
    }

    private AbstractPanelPart createChildPart(Object rawModel) {
        AbstractPanelPart createdPart;
        IAbstractPanelModel model = this.getPartModel().createChildSashModel(rawModel);
        if (model instanceof ITabFolderModel) {
            createdPart = new TabFolderPart(this, (ITabFolderModel)model, rawModel);
        } else if (model instanceof ISashPanelModel) {
            createdPart = new SashPanelPart(this, (ISashPanelModel)model, rawModel);
        } else {
            throw new IllegalArgumentException("Can't create child part for model of type '" + model.getClass().getName() + "'");
        }
        return createdPart;
    }

    private AbstractPanelPart createChildPart(Object rawModel, int childIndex) {
        AbstractPanelPart createdPart = this.createChildPart(rawModel);
        createdPart.createPartControl(this.getChildParent(childIndex));
        return createdPart;
    }

    @Override
    public Composite getControl() {
        return this.container;
    }

    @Override
    public void reparent(IPanelParent newParent, Composite swtParent) {
        this.parent = newParent;
        assert (this.getControl() != null);
        this.getControl().setParent(swtParent);
        this.garbageState = AbstractPart.GarbageState.REPARENTED;
    }

    @Override
    public void orphan() {
        if (this.garbageState == AbstractPart.GarbageState.UNVISITED) {
            this.garbageState = AbstractPart.GarbageState.ORPHANED;
            this.parent = null;
        }
    }

    @Override
    public void dispose() {
        if (this.container != null && !this.container.isDisposed()) {
            this.container.dispose();
        }
        this.container = null;
    }

    @Override
    public AbstractPart findPart(Point toFind) throws NotFoundException {
        Rectangle bounds = DragUtil.getDisplayBounds((Control)this.container);
        bounds = DragUtil.getDisplayBounds((Control)this.container.getLeftParent());
        if (bounds.contains(toFind)) {
            return this.currentChildParts[0].findPart(toFind);
        }
        bounds = DragUtil.getDisplayBounds((Control)this.container.getRightParent());
        if (bounds.contains(toFind)) {
            return this.currentChildParts[1].findPart(toFind);
        }
        throw new NotFoundException("Can't find a part at '" + toFind + "'");
    }

    @Override
    public AbstractPart findPartAt(Point toFind, Class<?> expectedTileType) {
        if (expectedTileType == this.getClass()) {
            return this;
        }
        Rectangle bounds = DragUtil.getDisplayBounds((Control)this.container);
        if (this.isVertical()) {
            if (toFind.y < bounds.y + bounds.height / 2) {
                return this.currentChildParts[0].findPartAt(toFind, expectedTileType);
            }
            return this.currentChildParts[1].findPartAt(toFind, expectedTileType);
        }
        if (toFind.x < bounds.x + bounds.width / 2) {
            return this.currentChildParts[0].findPartAt(toFind, expectedTileType);
        }
        return this.currentChildParts[1].findPartAt(toFind, expectedTileType);
    }

    private boolean isVertical() {
        return this.container.getOrientation() == 512;
    }

    @Override
    public AbstractPart findPart(Object control) {
        if (this.getControl() == control) {
            return this;
        }
        AbstractPart node = this.currentChildParts[0].findPart(control);
        if (node != null) {
            return node;
        }
        node = this.currentChildParts[1].findPart(control);
        if (node != null) {
            return node;
        }
        return null;
    }

    @Override
    public IDropTarget getDropTarget(Object draggedObject, TabFolderPart sourcePart, Point position) {
        return null;
    }

    @Override
    public boolean isPartFor(Object realModel) {
        return this.getRawModel() == realModel;
    }

    protected Object getRawModel() {
        return this.rawModel;
    }

    @Override
    public void synchronize2(PartLists partMap) {
        assert (this.model.getChildren().size() == 2);
        int i = 0;
        while (i < 2) {
            this.synchronizeChild(i, partMap);
            ++i;
        }
        i = 0;
        while (i < this.currentChildParts.length) {
            this.currentChildParts[i].synchronize2(partMap);
            ++i;
        }
    }

    private void synchronizeChild(int childIndex, PartLists existingParts) {
        AbstractPanelPart newTile;
        Object newModel = this.model.getChildren().get(childIndex);
        AbstractPanelPart currentChildPart = this.currentChildParts[childIndex];
        if (currentChildPart != null) {
            if (currentChildPart.isPartFor(newModel)) {
                currentChildPart.unchanged();
                return;
            }
            currentChildPart.orphan();
        }
        if ((newTile = existingParts.findPartFor(newModel)) != null) {
            newTile.reparent(this, this.getChildParent(childIndex));
        } else {
            newTile = this.createChildPart(newModel, childIndex);
        }
        this.setChildToSide(newTile, childIndex);
    }

    private Composite getChildParent(int childIndex) {
        if (childIndex == 0) {
            return this.container.getLeftParent();
        }
        return this.container.getRightParent();
    }

    private void setChildToSide(AbstractPanelPart newTile, int childIndex) {
        this.currentChildParts[childIndex] = newTile;
    }

    @Override
    public boolean visit(IPartVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean visitChildren(IPartVisitor visitor) {
        AbstractPanelPart[] abstractPanelPartArray = this.currentChildParts;
        int n = this.currentChildParts.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPanelPart child = abstractPanelPartArray[n2];
            if (!child.visit(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void showStatus() {
        Activator.log.debug("sash[" + this.currentChildParts.length + "]:" + ", disposed=" + this.container.isDisposed() + ", visible=" + this.container.isVisible() + ", garbState=" + (Object)((Object)this.garbageState) + ", " + this);
    }
}

