/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.service.edit.service;

import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.service.edit.Activator;
import org.eclipse.papyrus.service.edit.internal.ElementEditServiceProvider;
import org.eclipse.papyrus.service.edit.messages.Messages;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.service.edit.service.IElementEditServiceProvider;

public class ElementEditServiceUtils {
    public static IElementEditService getCommandProvider(Object objectToEdit) {
        if (objectToEdit != null) {
            try {
                return ElementEditServiceUtils.getEditServiceProvider().getEditService(objectToEdit);
            }
            catch (ServiceException e) {
                Activator.log.error(NLS.bind((String)Messages.ElementEditServiceUtils_UnableToFindElementType, (Object)objectToEdit), (Throwable)e);
            }
            catch (NullPointerException e) {
                Activator.log.error(NLS.bind((String)Messages.ElementEditServiceUtils_UnableToFindElementType, (Object)objectToEdit), (Throwable)e);
            }
        }
        return null;
    }

    public static IElementEditServiceProvider getEditServiceProvider() {
        try {
            return ElementEditServiceUtils.getEditServiceProviderFromElementTypeRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.ElementEditServiceUtils_UnableToFindServiceProvider, (Throwable)e);
            return null;
        }
    }

    protected static IElementEditServiceProvider getEditServiceProviderFromElementTypeRegistry() throws ServiceException {
        return ElementEditServiceProvider.getInstance();
    }
}

