/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences.BlockDefinitionDiagramNodePreferencePage;
import org.eclipse.papyrus.sysml.diagram.common.preferences.LabelPreferenceHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class OperationPreferencePage
extends BlockDefinitionDiagramNodePreferencePage {
    public static String prefKey = "BlockDefinition_shape_uml_operation_as_label";
    protected Button bttnVisibility;
    protected Button bttnName;
    protected Button bttnType;
    protected Button bttnModifiers;
    protected Button bttnParam_Direction;
    protected Button bttnParam_Name;
    protected Button bttnParam_Type;
    protected Button bttnParam_Multiplicity;
    protected Button bttnParam_DefaultValue;
    protected Button bttnParam_Modifiers;
    public static String prefLabelKey = "BlockDefinition_shape_uml_operation_as_label";
    private String labelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)prefLabelKey, (String)"label.display");
    private int propertyValue = this.getPreferenceStore().getInt(this.labelDisplayPreferenceKey);

    public OperationPreferencePage() {
        this.setPreferenceKey("BlockDefinition_shape_uml_operation_as_label");
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)prefKey, (String)"label.display"), 573464);
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnVisibility = this.createCheckButton((Composite)group, "Visibility", 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnVisibility.setLayoutData((Object)data);
        this.bttnName = this.createCheckButton((Composite)group, "Name", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnVisibility, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnName.setLayoutData((Object)data);
        this.bttnType = this.createCheckButton((Composite)group, "Type", 16);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnName, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnType.setLayoutData((Object)data);
        this.bttnModifiers = this.createCheckButton((Composite)group, "Modifiers", 128);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnType, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnModifiers.setLayoutData((Object)data);
        this.bttnParam_Direction = this.createCheckButton((Composite)group, "Param_Direction", 524288);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.bttnVisibility, 5);
        this.bttnParam_Direction.setLayoutData((Object)data);
        this.bttnParam_Name = this.createCheckButton((Composite)group, "Param_Name", 16384);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnVisibility, 85);
        data.top = new FormAttachment((Control)this.bttnVisibility, 5);
        this.bttnParam_Name.setLayoutData((Object)data);
        this.bttnParam_Type = this.createCheckButton((Composite)group, "Param_Type", 32768);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnName, 85);
        data.top = new FormAttachment((Control)this.bttnVisibility, 5);
        this.bttnParam_Type.setLayoutData((Object)data);
        this.bttnParam_Multiplicity = this.createCheckButton((Composite)group, "Param_Multiplicity", 65536);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnType, 85);
        data.top = new FormAttachment((Control)this.bttnVisibility, 5);
        this.bttnParam_Multiplicity.setLayoutData((Object)data);
        this.bttnParam_DefaultValue = this.createCheckButton((Composite)group, "Param_DefaultValue", 131072);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.bttnParam_Direction, 5);
        this.bttnParam_DefaultValue.setLayoutData((Object)data);
        this.bttnParam_Modifiers = this.createCheckButton((Composite)group, "Param_Modifiers", 262144);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnVisibility, 85);
        data.top = new FormAttachment((Control)this.bttnParam_Direction, 5);
        this.bttnParam_Modifiers.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected void loadDefaultPreferences() {
        this.propertyValue = this.getPreferenceStore().getDefaultInt(this.labelDisplayPreferenceKey);
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.bttnVisibility.setSelection((this.propertyValue & 2) == 2);
        this.bttnName.setSelection((this.propertyValue & 8) == 8);
        this.bttnType.setSelection((this.propertyValue & 0x10) == 16);
        this.bttnModifiers.setSelection((this.propertyValue & 0x80) == 128);
        this.bttnParam_Direction.setSelection((this.propertyValue & 0x80000) == 524288);
        this.bttnParam_Name.setSelection((this.propertyValue & 0x4000) == 16384);
        this.bttnParam_Type.setSelection((this.propertyValue & 0x8000) == 32768);
        this.bttnParam_Multiplicity.setSelection((this.propertyValue & 0x10000) == 65536);
        this.bttnParam_DefaultValue.setSelection((this.propertyValue & 0x20000) == 131072);
        this.bttnParam_Modifiers.setSelection((this.propertyValue & 0x40000) == 262144);
    }

    protected void storePreferences() {
        super.storePreferences();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.propertyValue != store.getInt(this.labelDisplayPreferenceKey)) {
            store.setValue(this.labelDisplayPreferenceKey, this.propertyValue);
        }
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            OperationPreferencePage operationPreferencePage = OperationPreferencePage.this;
            operationPreferencePage.propertyValue = operationPreferencePage.propertyValue ^ this.style;
            OperationPreferencePage.this.refreshButtons();
        }
    }
}

