/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		
 *		CEA LIST - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.gmf.diagram.common.locator;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

/**
 * Non diagram-specific class generated by GMF Tooling.
 */
public class MultilineCellEditorLocator implements CellEditorLocator {

	private IMultilineEditableFigure multilineEditableFigure;

	public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
		this.multilineEditableFigure = figure;
	}

	public IMultilineEditableFigure getMultilineEditableFigure() {
		return multilineEditableFigure;
	}

	public void relocate(CellEditor celleditor) {
		Text text = (Text)celleditor.getControl();
		Rectangle rect = getMultilineEditableFigure().getBounds().getCopy();
		rect.x = getMultilineEditableFigure().getEditionLocation().x;
		rect.y = getMultilineEditableFigure().getEditionLocation().y;
		getMultilineEditableFigure().translateToAbsolute(rect);
		if(getMultilineEditableFigure().getText().length() > 0) {
			rect.setSize(new Dimension(text.computeSize(rect.width, SWT.DEFAULT)));
		}
		if(!rect.equals(new Rectangle(text.getBounds()))) {
			text.setBounds(rect.x, rect.y, rect.width, rect.height);
		}
	}
}
