/*****************************************************************************
 * Copyright (c) 2009 Atos Origin.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Emilien Perico (Atos Origin) emilien.perico@atosorigin.com - Initial API and implementation
 *  CEA LIST - adapted in a non-UML specific manner.
 *
 *****************************************************************************/
package org.eclipse.papyrus.gmf.diagram.common.edit.policy;

import java.util.Collection;

import org.eclipse.emf.ecore.EObject;

/**
 * Interface to map links at semantic level.
 */
public interface ILinkMappingHelper {

	/**
	 * Get the sources.
	 * 
	 * @param link
	 *        the link.
	 * @return the sources.
	 */
	public Collection<?> getSource(EObject link);

	/**
	 * Get the targets.
	 * 
	 * @param link
	 *        the link.
	 * @return the targets.
	 */
	public Collection<?> getTarget(EObject link);
}
