/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.diagram.common.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAndExecuteCommand
extends PopupMenuCommand {
    private Command _selectedCmd;

    public SelectAndExecuteCommand(String label, Shell parentShell, List<Command> content) {
        super(label, parentShell);
        PopupMenu popupMenu = new PopupMenu(content, (ILabelProvider)new CommandLabelProvider());
        this.setPopupMenu(popupMenu);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        this._selectedCmd = (Command)cmdResult.getReturnValue();
        Assert.isTrue((this._selectedCmd != null && this._selectedCmd.canExecute() ? 1 : 0) != 0);
        this._selectedCmd.execute();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this._selectedCmd != null && this._selectedCmd.canUndo()) {
            this._selectedCmd.undo();
        }
        return super.doUndoWithResult(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this._selectedCmd != null && CommandUtilities.canRedo((Command)this._selectedCmd)) {
            this._selectedCmd.redo();
        }
        return super.doRedoWithResult(progressMonitor, info);
    }

    public static class CommandLabelProvider
    extends LabelProvider {
        public String getText(Object object) {
            String text = super.getText(object);
            if (object instanceof Command) {
                text = ((Command)object).getLabel();
            }
            return text;
        }
    }
}

