/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.diagram.common.edit.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.diagram.common.commands.DeferredCreateCommand;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.ILinkMappingHelper;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementBorderEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementLabelEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonDiagramDragDropEditPolicy
extends DiagramDragDropEditPolicy {
    protected IGraphicalTypeRegistry registry;
    private Set<String> specificDropList = null;
    protected ILinkMappingHelper linkMappingHelper;

    public CommonDiagramDragDropEditPolicy(ILinkMappingHelper linkMappingHelper) {
        this.linkMappingHelper = linkMappingHelper;
    }

    private Set<String> getSpecificDropList() {
        if (this.specificDropList == null) {
            this.specificDropList = this.getSpecificDropBehaviorTypes();
        }
        return this.specificDropList;
    }

    protected abstract Set<String> getSpecificDropBehaviorTypes();

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof AbstractElementBorderEditPart) {
                return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
            }
            if (!(droppedEditPart instanceof AbstractElementLabelEditPart)) continue;
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return super.getDropCommand(request);
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        CompoundCommand completeDropCommand = new CompoundCommand("DropObjectsAndArrange");
        if (dropRequest.getObjects().size() > 0 && dropRequest.getObjects().get(0) instanceof String) {
            return this.getDropFileCommand(dropRequest);
        }
        CompositeCommand gmfDropCommand = new CompositeCommand("DropObjects");
        for (EObject droppedObject : dropRequest.getObjects()) {
            gmfDropCommand.add((IUndoableOperation)this.getDropObjectCommand(dropRequest, droppedObject));
        }
        if (!gmfDropCommand.isEmpty()) {
            CommandResult result = gmfDropCommand.getCommandResult();
            List newValues = (List)result.getReturnValue();
            dropRequest.setResult((Object)newValues);
            RefreshConnectionsRequest refreshRequest = new RefreshConnectionsRequest(newValues);
            Command refreshCommand = this.getHost().getCommand((Request)refreshRequest);
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
            arrangeRequest.setViewAdaptersToArrange(newValues);
            Command arrangeCommand = this.getHost().getCommand((Request)arrangeRequest);
            ICommandProxy dropCommand = new ICommandProxy((ICommand)gmfDropCommand);
            completeDropCommand.add(dropCommand.chain(refreshCommand));
            completeDropCommand.add(arrangeCommand);
        }
        return completeDropCommand;
    }

    protected ICommand getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        Point location = dropRequest.getLocation().getCopy();
        View dropTargetView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        EObject dropTargetElement = dropTargetView.getElement();
        String droppedNodeType = this.registry.getNodeGraphicalType(droppedObject, dropTargetView.getType());
        String droppedEdgeType = this.registry.getEdgeGraphicalType(droppedObject);
        if (this.getSpecificDropList().contains(droppedNodeType) || this.getSpecificDropList().contains(droppedEdgeType)) {
            ICommand specificDropCommand = this.getSpecificDropCommand(dropRequest, droppedObject, droppedNodeType, droppedEdgeType);
            CompositeCommand cc = new CompositeCommand("Drop command");
            cc.compose((IUndoableOperation)specificDropCommand);
            if (this.isCopy(dropRequest)) {
                CompoundCommand specificDropCompoundCommand;
                ICommandProxy cp;
                if (specificDropCommand instanceof ICommandProxy) {
                    ICommandProxy specificDropCommandProxy = (ICommandProxy)specificDropCommand;
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, specificDropCommandProxy);
                } else if (specificDropCommand instanceof CompoundCommand && (cp = this.getCommandProxyFromCompoundCommand(specificDropCompoundCommand = (CompoundCommand)specificDropCommand)) != null) {
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, cp);
                }
            }
            return cc;
        }
        if ("undefined_type".equals(droppedNodeType) && "undefined_type".equals(droppedEdgeType)) {
            return this.getUnknownDropCommand(dropRequest, droppedObject);
        }
        if (!"undefined_type".equals(droppedNodeType)) {
            if (dropTargetView instanceof Diagram || dropTargetElement.eContents().contains((Object)droppedObject)) {
                return this.getDefaultDropNodeCommand(droppedNodeType, location, droppedObject, dropRequest);
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (!"undefined_type".equals(droppedEdgeType)) {
            Collection<?> sources = this.linkMappingHelper.getSource(droppedObject);
            Collection<?> targets = this.linkMappingHelper.getTarget(droppedObject);
            if (sources.size() > 0 && targets.size() > 0) {
                EObject source = (EObject)sources.toArray()[0];
                EObject target = (EObject)targets.toArray()[0];
                return this.getDefaultDropEdgeCommand(droppedObject, source, target, droppedEdgeType, location);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommandProxy getCommandProxyFromCompoundCommand(CompoundCommand cc) {
        if (cc != null && cc.getCommands() != null) {
            for (Object command : cc.getCommands()) {
                if (command instanceof ICommandProxy) {
                    return (ICommandProxy)command;
                }
                if (!(command instanceof CompoundCommand)) continue;
                this.getCommandProxyFromCompoundCommand((CompoundCommand)command);
            }
        }
        return null;
    }

    protected void createDeferredCommandWithCommandResult(EObject droppedObject, CompositeCommand cc, ICommandProxy specificDropCommandProxy) {
        Object object;
        if (specificDropCommandProxy != null && specificDropCommandProxy.getICommand() != null && specificDropCommandProxy.getICommand().getCommandResult() != null && specificDropCommandProxy.getICommand().getCommandResult().getReturnValue() != null && (object = specificDropCommandProxy.getICommand().getCommandResult().getReturnValue()) instanceof Collection) {
            for (Object o : (Collection)object) {
                if (!(o instanceof CreateViewRequest.ViewDescriptor)) continue;
                CreateViewRequest.ViewDescriptor viewDescritor = (CreateViewRequest.ViewDescriptor)o;
                DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)viewDescritor, this.getHost().getViewer());
                cc.compose((IUndoableOperation)createCommand2);
            }
        }
    }

    protected ICommand getDefaultDropNodeCommand(String droppedObjectGraphicalType, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(droppedObjectGraphicalType, absoluteLocation, droppedObject, null);
    }

    protected ICommand getDefaultDropNodeCommand(String droppedObjectGraphicalType, Point absoluteLocation, EObject droppedObject, DropObjectsRequest request) {
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, droppedObjectGraphicalType, -1, true, this.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(absoluteLocation);
        Command command = this.getHost().getCommand((Request)createViewRequest);
        if (this.isCopy(request) && createViewRequest.getNewObject() instanceof List) {
            for (Object object : (List)createViewRequest.getNewObject()) {
                if (!(object instanceof IAdaptable)) continue;
                DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)object, this.getHost().getViewer());
                command.chain((Command)new ICommandProxy((ICommand)createCommand2));
            }
        }
        return new CommandProxyWithResult(command, (Object)descriptor);
    }

    public boolean isCopy(DropObjectsRequest dropRequest) {
        int eventDetail;
        return dropRequest != null && dropRequest.getExtendedData() != null && dropRequest.getExtendedData().get("EVENT_DETAIL") instanceof Integer && ((eventDetail = ((Integer)dropRequest.getExtendedData().get("EVENT_DETAIL")).intValue()) & 1) != 0;
    }

    protected ICommand getDefaultDropEdgeCommand(EObject droppedObject, EObject source, EObject target, String droppedEdgeType, Point absoluteLocation) {
        CompositeCommand completeDropCommand = new CompositeCommand("CompleteDropEdge");
        Set<View> sourceViews = this.getViews(source);
        Set<View> targetViews = this.getViews(target);
        SemanticAdapter sourceViewAdapter = null;
        SemanticAdapter targetViewAdapter = null;
        if (sourceViews.isEmpty() || targetViews.isEmpty()) {
            CompositeCommand createEndViewsCommand = new CompositeCommand("CreateSourceTargetViews");
            View dropContainerView = ((IGraphicalEditPart)this.getHost()).getNotationView();
            EObject dropContainerElement = dropContainerView.getElement();
            if (sourceViews.isEmpty()) {
                if (dropContainerElement.eContents().contains((Object)source)) {
                    ICommand dropSourceCommand = this.getDefaultDropNodeCommand(this.registry.getNodeGraphicalType(source, dropContainerView.getType()), absoluteLocation.getCopy(), source);
                    CompositeCommand.compose((ICommand)createEndViewsCommand, (ICommand)dropSourceCommand);
                    sourceViewAdapter = (IAdaptable)dropSourceCommand.getCommandResult().getReturnValue();
                } else {
                    return UnexecutableCommand.INSTANCE;
                }
            }
            if (targetViews.isEmpty()) {
                if (dropContainerElement.eContents().contains((Object)target)) {
                    ICommand dropTargetCommand = this.getDefaultDropNodeCommand(this.registry.getNodeGraphicalType(target, dropContainerView.getType()), absoluteLocation.getCopy(), target);
                    CompositeCommand.compose((ICommand)createEndViewsCommand, (ICommand)dropTargetCommand);
                    targetViewAdapter = (IAdaptable)dropTargetCommand.getCommandResult().getReturnValue();
                } else {
                    return UnexecutableCommand.INSTANCE;
                }
            }
            CompositeCommand.compose((ICommand)completeDropCommand, (ICommand)createEndViewsCommand);
        }
        if (!sourceViews.isEmpty()) {
            sourceViewAdapter = new SemanticAdapter(null, sourceViews.toArray()[0]);
        }
        if (!targetViews.isEmpty()) {
            targetViewAdapter = new SemanticAdapter(null, targetViews.toArray()[0]);
        }
        SemanticAdapter droppedObjectAdapter = new SemanticAdapter(droppedObject, null);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)droppedObjectAdapter, droppedEdgeType, this.getDiagramPreferencesHint());
        CommonDeferredCreateConnectionViewCommand createConnectionViewCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), droppedEdgeType, (IAdaptable)sourceViewAdapter, (IAdaptable)targetViewAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        createConnectionViewCommand.setElement(droppedObject);
        CompositeCommand.compose((ICommand)completeDropCommand, (ICommand)createConnectionViewCommand);
        return completeDropCommand.reduce();
    }

    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getUnknownDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject) {
        return UnexecutableCommand.INSTANCE;
    }

    protected EditPartViewer getViewer() {
        return ((IGraphicalEditPart)this.getHost()).getViewer();
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected PreferencesHint getDiagramPreferencesHint() {
        return ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint();
    }

    private Set<View> getViews(EObject eObject) {
        HashSet<View> views = new HashSet<View>();
        View hostView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        View hostDiagram = hostView instanceof Diagram ? hostView : hostView.getDiagram();
        EReference[] refs = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
        Collection relatedViews = EMFCoreUtil.getReferencers((EObject)eObject, (EReference[])refs);
        for (View currentView : relatedViews) {
            if (currentView.getDiagram() != hostDiagram) continue;
            views.add(currentView);
        }
        return views;
    }
}

