/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.log.LogHelper;
import org.eclipse.papyrus.sysml.activities.provider.ActivitiesItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.allocations.provider.AllocationsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.blocks.provider.BlocksItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.constraints.provider.ConstraintsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.diagram.common.dialogs.UMLLabelProvider;
import org.eclipse.papyrus.sysml.modelelements.provider.ModelelementsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.papyrus.sysml.portandflows.provider.PortandflowsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.requirements.provider.RequirementsItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.sysml.diagram.common";
    private static Activator plugin;
    public static LogHelper log;
    private ComposedAdapterFactory adapterFactory;
    private UMLLabelProvider labelProvider;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getInstance() {
        return plugin;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public IPreferenceStore getPreferenceStore() {
        IPreferenceStore store = org.eclipse.papyrus.preferences.Activator.getDefault().getPreferenceStore();
        return store;
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public Image getImage(ENamedElement element) {
        String imageKey = element.getName();
        Image image = this.getImageRegistry().get(imageKey);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            this.getImageRegistry().put(imageKey, imageDescriptor);
            image = this.getImageRegistry().get(imageKey);
        }
        return image;
    }

    public Image getFlowPortImage(FlowPort flowport, int side) {
        String imageKey = "FlowPort_";
        if (flowport.isIsAtomic()) {
            if (flowport.getDirection() == FlowDirection.IN) {
                imageKey = String.valueOf(imageKey) + "IN_";
            } else if (flowport.getDirection() == FlowDirection.OUT) {
                imageKey = String.valueOf(imageKey) + "OUT_";
            } else if (flowport.getDirection() == FlowDirection.INOUT) {
                imageKey = String.valueOf(imageKey) + "INOUT_";
            }
            imageKey = String.valueOf(imageKey) + "A_";
        } else {
            imageKey = String.valueOf(imageKey) + "NA_";
        }
        if (side == 8) {
            imageKey = String.valueOf(imageKey) + "WEST";
        } else if (side == 1) {
            imageKey = String.valueOf(imageKey) + "NORTH";
        } else if (side == 4) {
            imageKey = String.valueOf(imageKey) + "SOUTH";
        } else if (side == 16) {
            imageKey = String.valueOf(imageKey) + "EAST";
        } else if (side == 9) {
            imageKey = String.valueOf(imageKey) + "NORTH_WEST";
        } else if (side == 17) {
            imageKey = String.valueOf(imageKey) + "NORTH_EAST";
        } else if (side == 20) {
            imageKey = String.valueOf(imageKey) + "SOUTH_EAST";
        } else if (side == 12) {
            imageKey = String.valueOf(imageKey) + "SOUTH_WEST";
        }
        Image image = this.getImageRegistry().get(imageKey);
        if (image == null) {
            ImageDescriptor imageDescriptor = Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("/icons/flowports/" + imageKey + ".gif"));
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            this.getImageRegistry().put(imageKey, imageDescriptor);
            image = this.getImageRegistry().get(imageKey);
        }
        return image;
    }

    public LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new UMLLabelProvider();
        }
        return this.labelProvider;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ActivitiesItemProviderAdapterFactory());
        factories.add(new AllocationsItemProviderAdapterFactory());
        factories.add(new BlocksItemProviderAdapterFactory());
        factories.add(new ConstraintsItemProviderAdapterFactory());
        factories.add(new ModelelementsItemProviderAdapterFactory());
        factories.add(new PortandflowsItemProviderAdapterFactory());
        factories.add(new RequirementsItemProviderAdapterFactory());
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    private ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return this.getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }
}

