/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.dialogs;

import java.util.Collection;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.gmf.diagram.common.provider.ElementTypeLabelProvider;
import org.eclipse.papyrus.service.edit.commands.ConfigureFeatureCommandFactory;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.sysml.diagram.common.dialogs.CreateOrSelectTypeDialog;
import org.eclipse.papyrus.sysml.diagram.common.messages.Messages;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateOrSelectValuePropertyTypeDialog
extends CreateOrSelectTypeDialog {
    protected ComboViewer newTypeKindComboViewer = null;
    protected Combo newTypeKindCombo = null;
    protected IElementType[] valueTypeKind = new IElementType[]{UMLElementTypes.DATA_TYPE, SysMLElementTypes.VALUE_TYPE, UMLElementTypes.PRIMITIVE_TYPE, UMLElementTypes.ENUMERATION};
    protected IElementType newTypeKind = UMLElementTypes.DATA_TYPE;

    public CreateOrSelectValuePropertyTypeDialog(Shell shell, NamedElement owner) {
        super(shell, (EObject)owner, (IElementType)UMLElementTypes.DATA_TYPE, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), null, (IElementType)UMLElementTypes.PACKAGE, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), null);
    }

    protected void createFormCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getCreationSectionTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.creationRadio = pToolkit.createButton(lBody, this.getCreationSectionRadioLabel(), 16);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        pToolkit.createLabel(lBody, this.getNewTypeNameLabel(), 0);
        this.newTypeNameText = pToolkit.createText(lBody, "", 2048);
        this.newTypeNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.newTypeNameText.setFocus();
        pToolkit.createLabel(lBody, this.getNewTypeContainerNameLabel(), 0);
        this.newTypeContainerNameText = pToolkit.createText(lBody, this.labelProvider.getText((Object)this.newTypeContainer), 2056);
        this.newTypeContainerNameText.setLayoutData((Object)new GridData(768));
        this.newTypeContainerButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = Activator.getInstance().getImage((ENamedElement)this.containerType.getEClass());
        if (this.containerEClass != null) {
            image = Activator.getInstance().getImage((ENamedElement)this.containerEClass);
        }
        this.newTypeContainerButton.setImage(image);
        this.newTypeContainerButton.setLayoutData((Object)new GridData(0));
        pToolkit.createLabel(lBody, this.getNewTypeKindLabel(), 0);
        this.newTypeKindCombo = new Combo(lBody, 12);
        this.newTypeKindComboViewer = new ComboViewer(this.newTypeKindCombo);
        pToolkit.adapt((Composite)this.newTypeKindCombo);
        this.newTypeKindCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.newTypeKindComboViewer.setLabelProvider((IBaseLabelProvider)new ElementTypeLabelProvider());
        this.newTypeKindComboViewer.add((Object[])this.valueTypeKind);
        this.newTypeKindComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.valueTypeKind[0]));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void buildNewTypeCreateCommand() {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((Object)this.newTypeContainer);
        if (commandService != null) {
            CreateElementRequest createTypeRequest = new CreateElementRequest(this.newTypeContainer, this.newTypeKind);
            createTypeRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)this.newTypeNameText.getText()));
            this.newTypeCreateCommand = commandService.getEditCommand((IEditCommandRequest)createTypeRequest);
        }
    }

    protected void hookListeners() {
        super.hookListeners();
        ModifyListener newTypeKindListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ISelection sel = CreateOrSelectValuePropertyTypeDialog.this.newTypeKindComboViewer.getSelection();
                if (sel instanceof StructuredSelection) {
                    Object type = ((StructuredSelection)sel).getFirstElement();
                    CreateOrSelectValuePropertyTypeDialog.this.newTypeKind = type instanceof IElementType ? (IElementType)type : null;
                    CreateOrSelectValuePropertyTypeDialog.this.setNewTypeName(null);
                }
            }
        };
        this.newTypeKindCombo.addModifyListener(newTypeKindListener);
    }

    protected void setNewTypeName(String text) {
        String name = text;
        if (text == null) {
            name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)this.newTypeKind.getEClass().getName(), (Collection)this.newTypeContainer.eContents());
            if (this.newTypeKind == SysMLElementTypes.VALUE_TYPE) {
                name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)BlocksPackage.eINSTANCE.getValueType().getName(), (Collection)this.newTypeContainer.eContents());
            }
            this.newTypeNameText.setText(name);
        } else {
            this.newTypeNameText.setText(name);
            this.newTypeName = name;
        }
        this.validateNewTypeName();
        this.refreshOkButton();
    }

    protected String getDialogTitle() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_DialogTitle;
    }

    protected String getSelectionSectionTitle() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_SelectionSectionTitle;
    }

    protected String getSelectionSectionRadioLabel() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_SelectionSectionRadioLabel;
    }

    protected String getCreationSectionTitle() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_CreationSectionTitle;
    }

    protected String getCreationSectionRadioLabel() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_CreationSectionRadioLabel;
    }

    protected String getNewTypeNameLabel() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_NewTypeNameLabel;
    }

    protected String getNewTypeKindLabel() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_NewTypeKindLabel;
    }

    protected String getNewTypeContainerNameLabel() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_NewTypeContainerNameLabel;
    }

    protected String getNewTypeContainerDialogTitle() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_SelectNewTypeContainerDialogTitle;
    }

    protected String getNewTypeContainerDialogMessage() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_SelectNewTypeContainerDialogMessage;
    }

    protected String getTypeDialogTitle() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_SelectTypeDialogTitle;
    }

    protected String getTypeDialogMessage() {
        return Messages.CreateOrSelectValuePropertyTypeDialog_SelectTypeDialogMessage;
    }
}

