/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.utils;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.resource.NotFoundException;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class SysMLSelectionTester
extends PropertyTester {
    public static final String IS_SYSML_MODEL = "isSysMLModel";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof PapyrusMultiDiagramEditor)) {
            return false;
        }
        Boolean currentValue = null;
        if (IS_SYSML_MODEL.equals(property)) {
            currentValue = this.testSysMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testSysMLModelNature(Object receiver) {
        boolean isSysMLModel = false;
        try {
            Profile sysml;
            EObject root;
            ServiceUtilsForActionHandlers serviceUtils = new ServiceUtilsForActionHandlers();
            UmlModel openedModel = (UmlModel)serviceUtils.getModelSet().getModel("org.eclipse.papyrus.resource.uml.UmlModel");
            if (openedModel != null && (root = openedModel.lookupRoot()) instanceof Package && (sysml = ((Package)root).getAppliedProfile(SysmlResource.SYSML_ID)) != null) {
                isSysMLModel = true;
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        return isSysMLModel;
    }
}

