/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.factory;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.factory.ConnectorViewFactory;
import org.eclipse.papyrus.uml.diagram.common.utils.AssociationViewUtils;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;

public class AssociationLinkViewFactory
extends ConnectorViewFactory {
    protected List createStyles(View view) {
        EObjectValueStyle sourceStyle = NotationFactory.eINSTANCE.createEObjectValueStyle();
        sourceStyle.setName("semantic_source_end");
        EObjectValueStyle targetStyle = NotationFactory.eINSTANCE.createEObjectValueStyle();
        targetStyle.setName("semantic_target_end");
        view.getStyles().add((Object)sourceStyle);
        view.getStyles().add((Object)targetStyle);
        return super.createStyles(view);
    }

    public View createView(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge view = (Edge)super.createView(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
        if (view != null && view.getElement() != null && view.getElement() instanceof Association) {
            Association association = (Association)view.getElement();
            assert (association.getMemberEnds().size() == 2);
            Property propertySource = (Property)association.getMemberEnds().get(0);
            Property propertyTarget = (Property)association.getMemberEnds().get(1);
            AssociationViewUtils.setSourceSemanticEnd((View)view, propertySource);
            AssociationViewUtils.setTargetSemanticEnd((View)view, propertyTarget);
        }
        return view;
    }

    protected void decorateView(View containerView, View view, IAdaptable element, String semanticHint, int index, boolean persisted) {
        AssociationLinkViewFactory.getViewService().createNode(element, view, "linklabel_uml_appliedstereotype", -1, persisted, this.getPreferencesHint());
        AssociationLinkViewFactory.getViewService().createNode(element, view, "linklabel_uml_namedelement_name", -1, persisted, this.getPreferencesHint());
        AssociationLinkViewFactory.getViewService().createNode(element, view, "linklabel_uml_association_source_role", -1, persisted, this.getPreferencesHint());
        AssociationLinkViewFactory.getViewService().createNode(element, view, "linklabel_uml_association_source_multiplicity", -1, persisted, this.getPreferencesHint());
        AssociationLinkViewFactory.getViewService().createNode(element, view, "linklabel_uml_association_target_role", -1, persisted, this.getPreferencesHint());
        AssociationLinkViewFactory.getViewService().createNode(element, view, "linklabel_uml_association_target_multiplicity", -1, persisted, this.getPreferencesHint());
        super.decorateView(containerView, view, element, semanticHint, index, persisted);
    }
}

