/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEndLabelParser
extends PropertyLabelParser {
    protected static final String ALT_MODIFIER_FORMAT = "{%s}%s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Property) {
            ValueSpecification valueSpecification;
            Property property = (Property)eObject;
            if ((flags & 2) == 2) {
                String visibility;
                switch (property.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format("%s ", visibility);
            }
            if ((flags & 4) == 4 && property.isDerived()) {
                result = String.format("%s/", result);
            }
            if ((flags & 8) == 8 && property.isSetName()) {
                String name = property.getName();
                if ((flags & 0x400000) == 0x400000 || property.getOwningAssociation() == null || !property.getOwningAssociation().getOwnedEnds().contains((Object)property)) {
                    result = String.format("%s%s", result, name);
                }
            }
            if ((flags & 0x10) == 16) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = property.getType().getName();
                }
                if ((flags & 0x200000) == 0x200000 || !"<Undefined>".equals(type)) {
                    result = String.format("%s: %s", result, type);
                }
            }
            if ((flags & 0x20) == 32) {
                String upper;
                String lower = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getLowerValue()) : "1";
                String string = upper = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getUpperValue()) : "1";
                if ((flags & 0x100000) == 0x100000 || !"1".equals(lower) || !"1".equals(upper)) {
                    result = lower.equals(upper) ? String.format("%s [%s]", result, lower, upper) : String.format("%s [%s..%s]", result, lower, upper);
                }
            }
            if ((flags & 0x40) == 64 && property.getDefaultValue() != null && ((valueSpecification = property.getDefaultValue()) instanceof InstanceValue && property.getType().equals(valueSpecification.getType()) || !(valueSpecification instanceof InstanceValue))) {
                result = String.format("%s= %s", result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
            }
            if ((flags & 0x80) == 128) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append(sb.length() == 0 ? p.getName() : ", redefines " + p.getName());
                    }
                }
                if (sb.length() != 0) {
                    result = String.format(ALT_MODIFIER_FORMAT, sb.toString(), result);
                }
            }
        }
        return result;
    }

    @Override
    public Map<Integer, String> getMasks() {
        return Collections.emptyMap();
    }
}

