/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterLabelParser
extends NamedElementLabelParser {
    protected static final String DIRECTION_FORMAT = "%s %s";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MULTIPLICITY_FORMAT = "%s [%s..%s]";
    protected static final String DEFAULT_VALUE_FORMAT = "%s= %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Parameter) {
            Parameter parameter = (Parameter)eObject;
            if ((flags & 0x80000) == 524288) {
                ValueSpecification valueSpecification;
                String upper;
                String direction;
                switch (parameter.getDirection().getValue()) {
                    case 0: {
                        direction = "in";
                        break;
                    }
                    case 2: {
                        direction = "out";
                        break;
                    }
                    case 1: {
                        direction = "inout";
                        break;
                    }
                    case 3: {
                        direction = "return";
                        break;
                    }
                    default: {
                        direction = "in";
                    }
                }
                result = String.format(DIRECTION_FORMAT, direction, result);
                if ((flags & 0x4000) == 16384 && parameter.isSetName()) {
                    String name = parameter.getName();
                    result = String.format(NAME_FORMAT, result, name);
                }
                if ((flags & 0x8000) == 32768) {
                    String type = "<Undefined>";
                    if (parameter.getType() != null) {
                        type = parameter.getType().getName();
                    }
                    if ((flags & 0x200000) == 0x200000 || !"<Undefined>".equals(type)) {
                        result = String.format(TYPE_FORMAT, result, type);
                    }
                }
                String lower = parameter.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)parameter.getLowerValue()) : "1";
                String string = upper = parameter.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)parameter.getUpperValue()) : "1";
                if (!((flags & 0x10000) != 65536 || "1".equals(lower) && "1".equals(upper))) {
                    result = String.format(MULTIPLICITY_FORMAT, result, lower, upper);
                }
                if ((flags & 0x20000) == 131072 && parameter.getDefaultValue() != null && ((valueSpecification = parameter.getDefaultValue()) instanceof InstanceValue && parameter.getType().equals(valueSpecification.getType()) || !(valueSpecification instanceof InstanceValue))) {
                    result = String.format(DEFAULT_VALUE_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
                }
                if ((flags & 0x40000) == 262144) {
                    StringBuffer sb = new StringBuffer();
                    if (parameter.isOrdered()) {
                        sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                    }
                    if (parameter.isUnique()) {
                        sb.append(sb.length() == 0 ? "unique" : ", unique");
                    }
                    if (parameter.isStream()) {
                        sb.append(sb.length() == 0 ? "stream" : ", stream");
                    }
                    if (parameter.isException()) {
                        sb.append(sb.length() == 0 ? "exception" : ", exception");
                    }
                    if (sb.length() != 0) {
                        result = String.format(MODIFIER_FORMAT, result, sb.toString());
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getParameter_Direction().equals(feature) || UMLPackage.eINSTANCE.getParameter_DefaultValue().equals(feature) || UMLPackage.eINSTANCE.getParameter_IsStream().equals(feature) || UMLPackage.eINSTANCE.getParameter_IsException().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Parameter) {
            Parameter semElement = (Parameter)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
            if (semElement.getDefaultValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getDefaultValue());
            }
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(6);
        masks.put(524288, "Parameter direction");
        masks.put(16384, "Parameter name");
        masks.put(32768, "Parameter type");
        masks.put(65536, "Parameter multiplicity");
        masks.put(131072, "Parameter default value");
        masks.put(262144, "Parameter modifiers");
        return masks;
    }
}

