/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.compatibility.IDiagramVersionUpdater;
import org.eclipse.papyrus.sysml.diagram.internalblock.compatibility.OldElementTypes;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;

public class DiagramVersionUpdater
implements IDiagramVersionUpdater {
    public int update(Diagram diagram, String oldVersion, String newVersion) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        if ("undefined".equals(oldVersion) && "0.8.1".equals(newVersion)) {
            try {
                editingDomain.getCommandStack().execute(this.getUpdateCommandFromUndefinedTo_081(diagram));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private Command getUpdateCommandFromUndefinedTo_081(final Diagram diagram) throws Exception {
        RecordingCommand command = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)diagram), "Diagram version updater (from undefined to 0.8.1)"){
            private Map<String, String> conversionMapping;
            {
                super($anonymous0, $anonymous1);
                this.conversionMapping = new HashMap<String, String>();
            }

            private void initializeMappings() {
                this.conversionMapping.put(OldElementTypes.CLASS.getSemanticHint(), "shape_sysml_block_as_composite");
                this.conversionMapping.put("5156", "label_sysml_block_name");
                this.conversionMapping.put("7073", "compartment_sysml_structure");
                this.conversionMapping.put(OldElementTypes.PROPERTY_CN.getSemanticHint(), "shape_sysml_blockproperty_as_composite");
                this.conversionMapping.put("5126", "label_uml_property_label");
                this.conversionMapping.put("7077", "compartment_sysml_blockproperty_structure");
                this.conversionMapping.put("6029", "affixedlabel_uml_appliedstereotype");
                this.conversionMapping.put(OldElementTypes.CONNECTOR.getSemanticHint(), "link_uml_connector");
                this.conversionMapping.put("6025", "linklabel_uml_appliedstereotype");
                this.conversionMapping.put("6050", "linklabel_uml_connector_label");
                this.conversionMapping.put("6051", "linklabel_uml_connector_source_multiplicity");
                this.conversionMapping.put("6052", "linklabel_uml_connector_target_multiplicity");
            }

            protected void doExecute() {
                this.initializeMappings();
                ArrayList<View> blockViews = new ArrayList<View>();
                ArrayList<View> portViews = new ArrayList<View>();
                TreeIterator it = diagram.eAllContents();
                while (it.hasNext()) {
                    EObject currentEObject = (EObject)it.next();
                    if (!(currentEObject instanceof View)) continue;
                    View currentView = (View)currentEObject;
                    if (this.conversionMapping.containsKey(currentView.getType())) {
                        if (currentView.getType().equals(OldElementTypes.CLASS.getSemanticHint())) {
                            blockViews.add(currentView);
                        }
                        currentView.setType(this.conversionMapping.get(currentView.getType()));
                    }
                    if (!currentView.getType().equals(OldElementTypes.PORT_CN.getSemanticHint()) && !currentView.getType().equals("5125")) continue;
                    portViews.add(currentView);
                }
                for (View portView : portViews) {
                    EObject eObject = portView.getElement();
                    if (((ISpecializationType)SysMLElementTypes.FLOW_PORT).getMatcher().matches(eObject)) {
                        if (portView.getType().equals(OldElementTypes.PORT_CN.getSemanticHint())) {
                            portView.setType("shape_sysml_flowport_as_affixed");
                        }
                        if (!portView.getType().equals("5125")) continue;
                        portView.setType("affixedlabel_sysml_flowport_label");
                        continue;
                    }
                    if (portView.getType().equals(OldElementTypes.PORT_CN.getSemanticHint())) {
                        portView.setType("shape_uml_port_as_affixed");
                    }
                    if (!portView.getType().equals("5125")) continue;
                    portView.setType("affixedlabel_uml_port_label");
                }
                for (View blockView : blockViews) {
                    EAnnotation stereotypeAnnotation = blockView.getEAnnotation("Stereotype_Annotation");
                    blockView.getEAnnotations().remove((Object)stereotypeAnnotation);
                }
            }

            public boolean canUndo() {
                return false;
            }
        };
        return command;
    }
}

