/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.ILinkMappingHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.dnd.helper.CustomLinkMappingHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.CustomGraphicalTypeRegistry;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public CustomDragDropEditPolicy() {
        super((ILinkMappingHelper)new CustomLinkMappingHelper());
        this.registry = new CustomGraphicalTypeRegistry();
    }

    protected Set<String> getSpecificDropBehaviorTypes() {
        HashSet<String> specificDropBehaviorTypes = new HashSet<String>();
        specificDropBehaviorTypes.add("link_uml_connector");
        return specificDropBehaviorTypes;
    }

    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if ("link_uml_connector".equals(edgeType) && droppedEObject instanceof Connector) {
            return this.getConnectorDropCommand(dropRequest, (Connector)droppedEObject, edgeType);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private ICommand getConnectorDropCommand(DropObjectsRequest dropRequest, Connector droppedEObject, String edgeType) {
        if (droppedEObject.getEnds().size() != 2) {
            return UnexecutableCommand.INSTANCE;
        }
        ConnectorEnd source = (ConnectorEnd)droppedEObject.getEnds().get(0);
        ConnectorEnd target = (ConnectorEnd)droppedEObject.getEnds().get(1);
        Set<View> sourceViews = this.getViewsForConnectorEnd(source);
        Set<View> targetViews = this.getViewsForConnectorEnd(target);
        SemanticAdapter sourceViewAdapter = null;
        SemanticAdapter targetViewAdapter = null;
        if (sourceViews.isEmpty() || targetViews.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!sourceViews.isEmpty()) {
            sourceViewAdapter = new SemanticAdapter(null, sourceViews.toArray()[0]);
        }
        if (!targetViews.isEmpty()) {
            targetViewAdapter = new SemanticAdapter(null, targetViews.toArray()[0]);
        }
        SemanticAdapter droppedObjectAdapter = new SemanticAdapter((EObject)droppedEObject, null);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)droppedObjectAdapter, edgeType, this.getDiagramPreferencesHint());
        CommonDeferredCreateConnectionViewCommand createConnectionViewCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), edgeType, (IAdaptable)sourceViewAdapter, (IAdaptable)targetViewAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        createConnectionViewCommand.setElement((EObject)droppedEObject);
        return createConnectionViewCommand;
    }

    private Set<View> getViewsForConnectorEnd(ConnectorEnd end) {
        HashSet<View> views = new HashSet<View>();
        View hostView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        View hostDiagram = hostView instanceof Diagram ? hostView : hostView.getDiagram();
        EReference[] refs = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
        Collection relatedViews = EMFCoreUtil.getReferencers((EObject)end.getRole(), (EReference[])refs);
        for (View currentView : relatedViews) {
            if (currentView.getDiagram() != hostDiagram) continue;
            if (end.getPartWithPort() != null) {
                if (ViewUtil.getContainerView((View)currentView).getElement() != end.getPartWithPort()) continue;
                views.add(currentView);
                continue;
            }
            if (end.getRole() instanceof Port) {
                if (!(ViewUtil.getContainerView((View)currentView).getElement() instanceof EncapsulatedClassifier)) continue;
                views.add(currentView);
                continue;
            }
            views.add(currentView);
        }
        return views;
    }
}

