/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.gmf.diagram.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy.CustomDragDropEditPolicy;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.BlockDropHelper;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.ui.PlatformUI;

public class StructureClassifierDropEditPolicy
extends CustomDragDropEditPolicy {
    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        BlockDropHelper helper = new BlockDropHelper(this.getEditingDomain());
        if (dropRequest.getObjects().size() == 1) {
            Command dropAsTypedReference;
            ArrayList<Command> commandChoice = new ArrayList<Command>();
            Command dropAsTypedPart = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.PART_PROPERTY);
            if (dropAsTypedPart != null && dropAsTypedPart.canExecute()) {
                commandChoice.add(dropAsTypedPart);
            }
            if ((dropAsTypedReference = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.REFERENCE_PROPERTY)) != null && dropAsTypedReference.canExecute()) {
                commandChoice.add(dropAsTypedReference);
            }
            Command defaultDropCommand = super.getDropObjectsCommand(dropRequest);
            defaultDropCommand.setLabel("Default drop (Show dropped object in diagram)");
            if (defaultDropCommand != null && defaultDropCommand.canExecute()) {
                commandChoice.add(defaultDropCommand);
            }
            if (commandChoice.size() > 1) {
                SelectAndExecuteCommand selectCommand = new SelectAndExecuteCommand("Select drop action for ", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), commandChoice);
                return new ICommandProxy((ICommand)selectCommand);
            }
            if (commandChoice.size() == 1) {
                return (Command)commandChoice.get(0);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDropObjectsCommand(dropRequest);
    }
}

