/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.preferences;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.preferences.InternalBlockDiagramNodePreferencePage;

public class BlockCompositePreferencePage
extends InternalBlockDiagramNodePreferencePage {
    public static String prefKey = "InternalBlock_shape_sysml_block_as_composite";
    public static final Map<String, Boolean> compartmentDefaultVisibilityMap = new LinkedHashMap<String, Boolean>();
    public static final Map<String, Boolean> compartmentTitleDefaultVisibilityMap;

    static {
        compartmentDefaultVisibilityMap.put("structure", Boolean.TRUE);
        compartmentTitleDefaultVisibilityMap = new LinkedHashMap<String, Boolean>();
        compartmentTitleDefaultVisibilityMap.put("structure", Boolean.TRUE);
        compartmentTitleDefaultVisibilityMap.remove("structure");
        compartmentTitleDefaultVisibilityMap.put("structure", Boolean.FALSE);
        Collections.unmodifiableMap(compartmentDefaultVisibilityMap);
        Collections.unmodifiableMap(compartmentTitleDefaultVisibilityMap);
    }

    public BlockCompositePreferencePage() {
        this.setPreferenceKey("InternalBlock_shape_sysml_block_as_composite");
    }

    public static void initDefaults(IPreferenceStore store) {
        for (String compartmentName : compartmentDefaultVisibilityMap.keySet()) {
            String showCompartmentKey = PreferenceConstantHelper.getCompartmentElementConstant((String)prefKey, (String)compartmentName, (int)18);
            store.setDefault(showCompartmentKey, compartmentDefaultVisibilityMap.get(compartmentName).booleanValue());
        }
        for (String compartmentName : compartmentTitleDefaultVisibilityMap.keySet()) {
            String showCompartmentTitleKey = PreferenceConstantHelper.getCompartmentElementConstant((String)prefKey, (String)compartmentName, (int)19);
            store.setDefault(showCompartmentTitleKey, compartmentTitleDefaultVisibilityMap.get(compartmentName).booleanValue());
        }
    }

    protected void initializeCompartmentNamesList() {
        for (String name : compartmentDefaultVisibilityMap.keySet()) {
            this.compartmentNamesList.add(name);
        }
    }

    protected void initializeCompartmentTitlesList() {
        for (String name : compartmentTitleDefaultVisibilityMap.keySet()) {
            this.compartmentTitlesList.add(name);
        }
    }
}

