/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.provider;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.composite.providers.UMLViewProvider;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.ElementTypes;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.GraphicalTypeRegistry;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;

public class InheritedCompositeDiagramViewProvider
extends UMLViewProvider {
    protected IGraphicalTypeRegistry registry = new GraphicalTypeRegistry();

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge createdEdge = null;
        IElementType elementType = (IElementType)semanticAdapter.getAdapter(IElementType.class);
        if (elementType != null) {
            createdEdge = super.createEdge(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
        } else {
            EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
            String domainElementGraphicalType = semanticHint;
            if (domainElementGraphicalType == null) {
                domainElementGraphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownEdgeType(domainElementGraphicalType)) {
                if (ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createCommentAnnotatedElement_4002(containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createConstraintConstrainedElement_4003(containerView, index, persisted, preferencesHint);
                }
            }
        }
        if (createdEdge == null) {
            Activator.log.error((Throwable)new Exception("Could not create Edge."));
        }
        return createdEdge;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"InternalBlock".equals(diagramType)) {
            return false;
        }
        throw new UnsupportedOperationException("Should never be called by the " + diagramType + " diagram.");
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        if (op.getContainerView() == null) {
            return false;
        }
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"InternalBlock".equals(diagramType)) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType == ElementTypes.COMMENT_ANNOTATED_ELEMENT) {
            return true;
        }
        if (elementType == ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT) {
            return true;
        }
        if (elementType == null) {
            EObject domainElement = (EObject)op.getSemanticAdapter().getAdapter(EObject.class);
            String domainElementGraphicalType = op.getSemanticHint();
            if (domainElementGraphicalType == null) {
                domainElementGraphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownEdgeType(domainElementGraphicalType)) {
                return true;
            }
        }
        return false;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        if (op.getContainerView() == null) {
            return false;
        }
        String containerGraphicalType = op.getContainerView().getType();
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"InternalBlock".equals(diagramType)) {
            return false;
        }
        IElementType elementType = (IElementType)op.getSemanticAdapter().getAdapter(IElementType.class);
        if (elementType == UMLElementTypes.COMMENT) {
            if ("InternalBlock".equals(containerGraphicalType)) {
                return true;
            }
            if ("compartment_sysml_structure".equals(containerGraphicalType)) {
                return true;
            }
            if ("compartment_sysml_blockproperty_structure".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == UMLElementTypes.CONSTRAINT) {
            if ("InternalBlock".equals(containerGraphicalType)) {
                return true;
            }
            if ("compartment_sysml_structure".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == null) {
            EObject domainElement = (EObject)op.getSemanticAdapter().getAdapter(EObject.class);
            String domainElementGraphicalType = op.getSemanticHint();
            domainElementGraphicalType = domainElementGraphicalType == null ? this.registry.getNodeGraphicalType(domainElement, containerGraphicalType) : this.registry.getNodeGraphicalType(domainElementGraphicalType, containerGraphicalType);
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownNodeType(domainElementGraphicalType)) {
                return true;
            }
        }
        return false;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        String containerGraphicalType = containerView.getType();
        EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (semanticHint != null) {
            String graphicalType = this.registry.getNodeGraphicalType(semanticHint, containerGraphicalType);
            return super.createNode((IAdaptable)new SemanticAdapter(domainElement, null), containerView, graphicalType, index, persisted, preferencesHint);
        }
        String domainElementGraphicalType = this.registry.getNodeGraphicalType(domainElement, containerGraphicalType);
        if (!"undefined_type".equals(domainElementGraphicalType)) {
            return super.createNode(semanticAdapter, containerView, domainElementGraphicalType, index, persisted, preferencesHint);
        }
        Activator.log.error((Throwable)new Exception("Could not create Node."));
        return null;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"InternalBlock".equals(containerView.getDiagram().getType())) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"InternalBlock");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }
}

