/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.service.edit.commands.ConfigureFeatureCommandFactory;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class BlockDropHelper
extends ElementHelper {
    public BlockDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command getDropAsStructureItem(DropObjectsRequest request, GraphicalEditPart host, IElementType elementType) {
        String label = "";
        if (elementType == SysMLElementTypes.PART_PROPERTY) {
            label = "Create a new Part";
        }
        if (elementType == SysMLElementTypes.REFERENCE_PROPERTY) {
            label = "Create a new Reference";
        }
        CompoundCommand cc = new CompoundCommand(label);
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidStructureItemType(droppedEObject, elementType)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), this.getHostEObject(host), elementType);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getHostEObject(host));
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, "shape_sysml_blockproperty_as_composite", -1, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    private boolean isValidStructureItemType(Object object, IElementType elementType) {
        boolean isValid = false;
        if (object != null && object instanceof Type) {
            Type type = (Type)object;
            if ((elementType == SysMLElementTypes.PART_PROPERTY || elementType == SysMLElementTypes.REFERENCE_PROPERTY) && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)type)) {
                isValid = true;
            }
        }
        return isValid;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

