/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class PortDropHelper
extends ElementHelper {
    public PortDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command getDropPortOnPart(DropObjectsRequest request, GraphicalEditPart host) {
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidPort(droppedEObject, this.getHostEObject(host))) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getDropPortOnPart((Port)droppedEObject, request.getLocation().getCopy(), host);
    }

    public Command getDropPortOnPart(Port droppedPort, Point location, GraphicalEditPart host) {
        if (!this.isValidPort(droppedPort, this.getHostEObject(host))) {
            return UnexecutableCommand.INSTANCE;
        }
        String graphicalType = "shape_uml_port_as_affixed";
        if (((ISpecializationType)SysMLElementTypes.FLOW_PORT).getMatcher().matches((EObject)droppedPort)) {
            graphicalType = "shape_sysml_flowport_as_affixed";
        }
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new SemanticAdapter((EObject)droppedPort, null), Node.class, graphicalType, -1, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(location);
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        return viewCreateCommand;
    }

    private boolean isValidPort(Object object, EObject dropTarget) {
        boolean isValid = false;
        if (object != null && object instanceof Port && dropTarget != null && dropTarget instanceof TypedElement && ((TypedElement)dropTarget).getType() != null) {
            Type targetType = ((TypedElement)dropTarget).getType();
            if (((Port)object).eContainer() == targetType) {
                isValid = true;
            }
        }
        return isValid;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

