/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.policies.SysmlBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ConnectorReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connector)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ConnectableElement) || !(this.newEnd instanceof ConnectableElement)) {
            return false;
        }
        ConnectableElement target = null;
        EList ends = this.getLink().getEnds();
        if (ends != null && !ends.isEmpty()) {
            target = ((ConnectorEnd)ends.get(1)).getRole();
        }
        if (!(this.getLink().eContainer() instanceof StructuredClassifier)) {
            return false;
        }
        StructuredClassifier container = (StructuredClassifier)this.getLink().eContainer();
        return SysmlBaseItemSemanticEditPolicy.LinkConstraints.canExistConnector_4001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ConnectableElement) || !(this.newEnd instanceof ConnectableElement)) {
            return false;
        }
        ConnectableElement source = null;
        EList ends = this.getLink().getEnds();
        if (ends != null && !ends.isEmpty()) {
            source = ((ConnectorEnd)ends.get(0)).getRole();
        }
        if (!(this.getLink().eContainer() instanceof StructuredClassifier)) {
            return false;
        }
        StructuredClassifier container = (StructuredClassifier)this.getLink().eContainer();
        return SysmlBaseItemSemanticEditPolicy.LinkConstraints.canExistConnector_4001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        EList ends = this.getLink().getEnds();
        if (ends != null && !ends.isEmpty()) {
            ((ConnectorEnd)ends.get(0)).setRole(this.getNewSource());
            return CommandResult.newOKCommandResult((Object)this.getLink());
        }
        return CommandResult.newCancelledCommandResult();
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        EList ends = this.getLink().getEnds();
        if (ends != null && !ends.isEmpty()) {
            ((ConnectorEnd)ends.get(1)).setRole(this.getNewTarget());
            return CommandResult.newOKCommandResult((Object)this.getLink());
        }
        return CommandResult.newCancelledCommandResult();
    }

    protected Connector getLink() {
        return (Connector)this.getElementToEdit();
    }

    protected ConnectableElement getOldSource() {
        return (ConnectableElement)this.oldEnd;
    }

    protected ConnectableElement getNewSource() {
        return (ConnectableElement)this.newEnd;
    }

    protected ConnectableElement getOldTarget() {
        return (ConnectableElement)this.oldEnd;
    }

    protected ConnectableElement getNewTarget() {
        return (ConnectableElement)this.newEnd;
    }
}

