/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.edit.parts;

import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConstraintLabelEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConstraintPropertyNameEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.Property2EditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.policies.ConstraintPropertyItemSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.policies.CreateParameterEditPolicy;
import org.eclipse.papyrus.sysml.diagram.parametric.figures.CenteredWrappedLabel;
import org.eclipse.papyrus.sysml.diagram.parametric.helper.SelfCompartmentNotificationHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.locator.ParameterPositionLocator;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlElementTypes;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ConstraintPropertyEditPart
extends AbstractBorderedShapeEditPart {
    public static final int VISUAL_ID = 2003;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private SelfCompartmentNotificationHelper notifier = new SelfCompartmentNotificationHelper(this, (EStructuralFeature)UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute(), (IHintedType)SysmlElementTypes.Property_3002);

    public ConstraintPropertyEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ConstraintPropertyItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("create child", (EditPolicy)new CreateParameterEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (SysmlVisualIDRegistry.getVisualID(childView)) {
                    case 3002: {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ConstraintPropertyFigureDescriptor();
        return this.primaryShape;
    }

    public ConstraintPropertyFigureDescriptor getPrimaryShape() {
        return (ConstraintPropertyFigureDescriptor)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ConstraintPropertyNameEditPart) {
            ((ConstraintPropertyNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getConstraintPropertyFigureLabel());
            return true;
        }
        if (childEditPart instanceof ConstraintLabelEditPart) {
            ((ConstraintLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getConstraintLabel());
            return true;
        }
        if (childEditPart instanceof Property2EditPart) {
            ParameterPositionLocator locator = new ParameterPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((Property2EditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ConstraintPropertyNameEditPart) {
            return true;
        }
        if (childEditPart instanceof ConstraintLabelEditPart) {
            return true;
        }
        if (childEditPart instanceof Property2EditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((Property2EditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "ConstraintProperty";
        IPreferenceStore store = SysmlDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(SysmlVisualIDRegistry.getType(5001));
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"ConstraintProperty", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"ConstraintProperty", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"ConstraintProperty", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferenceConstantHelper.getElementConstant((String)"ConstraintProperty", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }

    public void activate() {
        super.activate();
        EObject parent = this.resolveSemanticElement();
        this.notifier.listenObject((Notifier)parent);
        if (parent instanceof ConstraintProperty) {
            Property property = ((ConstraintProperty)parent).getBase_Property();
            this.notifier.listenObject((Notifier)property);
            if (property.getType() != null) {
                this.notifier.listenObject((Notifier)property.getType());
            }
        }
        SelfCompartmentNotificationHelper.updatePropertiesParts(this, (EStructuralFeature)UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute(), (IHintedType)SysmlElementTypes.Property_3002);
    }

    public void deactivate() {
        this.notifier.unlistenAll();
        super.deactivate();
    }

    public void removeNotify() {
        this.notifier.unlistenAll();
        super.removeNotify();
    }

    public class ConstraintPropertyFigureDescriptor
    extends RoundedRectangle {
        private CenteredWrappedLabel fConstraintPropertyFigureLabel;
        private WrappingLabel fConstraintLabel;
        private boolean myUseLocalCoordinates = false;

        public ConstraintPropertyFigureDescriptor() {
            GridLayout layoutThis = new GridLayout();
            layoutThis.numColumns = 1;
            layoutThis.makeColumnsEqualWidth = true;
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setCornerDimensions(new Dimension(ConstraintPropertyEditPart.this.getMapMode().DPtoLP(25), ConstraintPropertyEditPart.this.getMapMode().DPtoLP(25)));
            this.setLineWidth(1);
            this.setMinimumSize(new Dimension(ConstraintPropertyEditPart.this.getMapMode().DPtoLP(200), ConstraintPropertyEditPart.this.getMapMode().DPtoLP(120)));
            this.createContents();
        }

        private void createContents() {
            this.fConstraintPropertyFigureLabel = new CenteredWrappedLabel();
            GridData constraintFConstraintPropertyFigureLabel = new GridData();
            constraintFConstraintPropertyFigureLabel.verticalAlignment = 3;
            constraintFConstraintPropertyFigureLabel.horizontalAlignment = 2;
            constraintFConstraintPropertyFigureLabel.horizontalIndent = 0;
            constraintFConstraintPropertyFigureLabel.horizontalSpan = 1;
            constraintFConstraintPropertyFigureLabel.verticalSpan = 1;
            constraintFConstraintPropertyFigureLabel.grabExcessHorizontalSpace = true;
            constraintFConstraintPropertyFigureLabel.grabExcessVerticalSpace = true;
            this.add((IFigure)this.fConstraintPropertyFigureLabel, constraintFConstraintPropertyFigureLabel);
            this.fConstraintLabel = new WrappingLabel();
            GridData constraintFConstraintLabel = new GridData();
            constraintFConstraintLabel.verticalAlignment = 1;
            constraintFConstraintLabel.horizontalAlignment = 3;
            constraintFConstraintLabel.horizontalIndent = 0;
            constraintFConstraintLabel.horizontalSpan = 1;
            constraintFConstraintLabel.verticalSpan = 1;
            constraintFConstraintLabel.grabExcessHorizontalSpace = true;
            constraintFConstraintLabel.grabExcessVerticalSpace = true;
            this.add((IFigure)this.fConstraintLabel, constraintFConstraintLabel);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public CenteredWrappedLabel getConstraintPropertyFigureLabel() {
            return this.fConstraintPropertyFigureLabel;
        }

        public WrappingLabel getConstraintLabel() {
            return this.fConstraintLabel;
        }
    }
}

