/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.diagram.common.draw2d.CenterLayout;
import org.eclipse.papyrus.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.Property2EditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.PropertyNameEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.policies.PropertyItemSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.parametric.figures.CenteredWrappedLabel;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlElementTypes;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2005;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public PropertyEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new PropertyItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new PropertyFigure();
        return this.primaryShape;
    }

    public PropertyFigure getPrimaryShape() {
        return (PropertyFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof PropertyNameEditPart) {
            ((PropertyNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getPropertyFigureLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return childEditPart instanceof PropertyNameEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "Property";
        IPreferenceStore store = SysmlDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(SysmlVisualIDRegistry.getType(5002));
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(SysmlElementTypes.Connector_4001);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof PropertyEditPart) {
            types.add(SysmlElementTypes.Connector_4001);
        }
        if (targetEditPart instanceof Property2EditPart) {
            types.add(SysmlElementTypes.Connector_4001);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == SysmlElementTypes.Connector_4001) {
            types.add(SysmlElementTypes.Property_2005);
            types.add(SysmlElementTypes.Property_3002);
        }
        return types;
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(SysmlElementTypes.Connector_4001);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == SysmlElementTypes.Connector_4001) {
            types.add(SysmlElementTypes.Property_2005);
            types.add(SysmlElementTypes.Property_3002);
        }
        return types;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"Property", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"Property", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"Property", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferenceConstantHelper.getElementConstant((String)"Property", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }

    public class PropertyFigure
    extends RectangleFigure {
        private CenteredWrappedLabel fPropertyFigureLabel;
        private boolean myUseLocalCoordinates = false;

        public PropertyFigure() {
            CenterLayout layoutThis = new CenterLayout();
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setLineWidth(1);
            this.setMinimumSize(new Dimension(PropertyEditPart.this.getMapMode().DPtoLP(100), PropertyEditPart.this.getMapMode().DPtoLP(40)));
            this.createContents();
        }

        private void createContents() {
            this.fPropertyFigureLabel = new CenteredWrappedLabel();
            this.add((IFigure)this.fPropertyFigureLabel);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public CenteredWrappedLabel getPropertyFigureLabel() {
            return this.fPropertyFigureLabel;
        }
    }
}

