/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConnectorEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConnectorNameEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConstraintLabelEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConstraintPropertyEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConstraintPropertyNameEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ParametricEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.Property2EditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.PropertyEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.PropertyName2EditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.PropertyNameEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class SysmlEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (SysmlVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new ParametricEditPart(view);
                }
                case 2003: {
                    return new ConstraintPropertyEditPart(view);
                }
                case 5001: {
                    return new ConstraintPropertyNameEditPart(view);
                }
                case 5004: {
                    return new ConstraintLabelEditPart(view);
                }
                case 2005: {
                    return new PropertyEditPart(view);
                }
                case 5002: {
                    return new PropertyNameEditPart(view);
                }
                case 3002: {
                    return new Property2EditPart(view);
                }
                case 5003: {
                    return new PropertyName2EditPart(view);
                }
                case 4001: {
                    return new ConnectorEditPart(view);
                }
                case 6001: {
                    return new ConnectorNameEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof IMultilineEditableFigure) {
            return new MultilineCellEditorLocator((IMultilineEditableFigure)source.getFigure());
        }
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class MultilineCellEditorLocator
    implements CellEditorLocator {
        private IMultilineEditableFigure multilineEditableFigure;

        public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
            this.multilineEditableFigure = figure;
        }

        public IMultilineEditableFigure getMultilineEditableFigure() {
            return this.multilineEditableFigure;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getMultilineEditableFigure().getBounds().getCopy();
            rect.x = this.getMultilineEditableFigure().getEditionLocation().x;
            rect.y = this.getMultilineEditableFigure().getEditionLocation().y;
            this.getMultilineEditableFigure().translateToAbsolute((Translatable)rect);
            if (this.getMultilineEditableFigure().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                    rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                } else {
                    int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                }
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

