/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.editpolicies.OldCommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.sysml.diagram.parametric.helper.ConnectorLinkMappingHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlElementTypes;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.PropertyLinkedToClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDiagramDragDropEditPolicy
extends OldCommonDiagramDragDropEditPolicy {
    private View containerView;

    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ConnectorLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> droppableElementsVisualId = new HashSet<Integer>();
        droppableElementsVisualId.add(4001);
        droppableElementsVisualId.add(2003);
        droppableElementsVisualId.add(2005);
        return droppableElementsVisualId;
    }

    public IElementType getUMLElementType(int elementID) {
        return SysmlElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        EObject e;
        this.containerView = containerView;
        if (domainElement instanceof Element && (e = this.getApplication(domainElement)) != null && e instanceof ConstraintProperty) {
            return 2003;
        }
        return SysmlVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return SysmlVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID, int linkVISUALID) {
        if (nodeVISUALID != -1) {
            switch (nodeVISUALID) {
                case 2003: {
                    return this.dropConstraintProperty(dropRequest, semanticLink, nodeVISUALID);
                }
                case 2005: {
                    return this.dropProperty(dropRequest, semanticLink, nodeVISUALID);
                }
            }
            return super.getSpecificDropCommand(dropRequest, semanticLink, nodeVISUALID, linkVISUALID);
        }
        if (linkVISUALID != -1) {
            switch (linkVISUALID) {
                case 4001: {
                    return this.dropConnector(dropRequest, semanticLink, linkVISUALID);
                }
            }
            return super.getSpecificDropCommand(dropRequest, semanticLink, nodeVISUALID, linkVISUALID);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConnector(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = ConnectorLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ConnectorLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sources.size() == 1 && targets.size() == 1) {
            ConnectorEnd sourceConnector = (ConnectorEnd)sources.toArray()[0];
            ConnectorEnd targetConnector = (ConnectorEnd)targets.toArray()[0];
            ConnectableElement source = sourceConnector.getRole();
            ConnectableElement target = targetConnector.getRole();
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Connector"), (Element)source, (Element)target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropConstraintProperty(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        CompositeCommand cc = new CompositeCommand("Drop");
        EObject droppedObject = this.getApplication((EObject)semanticElement);
        if (droppedObject != null) {
            cc = this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), droppedObject);
            return new ICommandProxy((ICommand)cc);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropProperty(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        PropertyLinkedToClassifier propertyLinkedToClassifier;
        EObject eObject = this.containerView.getElement();
        if (eObject instanceof Classifier && (propertyLinkedToClassifier = new PropertyLinkedToClassifier((Classifier)eObject, (Property)semanticElement)).isLinkedToClassifier()) {
            CompositeCommand cc = new CompositeCommand("Drop");
            cc = this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement);
            return new ICommandProxy((ICommand)cc);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return !LabelEditPart.class.isAssignableFrom(editPartClass);
    }

    private EObject getApplication(EObject domainElement) {
        if (this.getStereotypeAvailable(domainElement) != null && domainElement instanceof Element) {
            Element element = (Element)domainElement;
            EList applications = element.getStereotypeApplications();
            for (EObject eObject : applications) {
                if (!this.getStereotypeAvailable(domainElement).equals(eObject.eClass())) continue;
                return eObject;
            }
        }
        return null;
    }

    private EClass getStereotypeAvailable(EObject eObject) {
        if (eObject instanceof Property) {
            return ConstraintsPackage.Literals.CONSTRAINT_PROPERTY;
        }
        return null;
    }
}

