/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.helper;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.resource.Resource;
import org.eclipse.papyrus.resource.util.ResourceUtil;
import org.eclipse.papyrus.sysml.blocks.BlocksFactory;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.PropertyLinkedToClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ModelValidationHelper {
    private static final String NESTED_CONNECTOR_END_STEREOTYPE = "SysML::Blocks::NestedConnectorEnd";

    public static IStatus validateConnector(Connector connector, IValidationContext ctx) {
        if (EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) {
            UMLPackage.eINSTANCE.getConnector_End().equals(ctx.getFeature());
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateProperty(Property property, IValidationContext ctx) {
        if (EMFEventType.MOVE.equals(ctx.getEventType()) || EMFEventType.SET.equals(ctx.getEventType())) {
            for (ConnectorEnd end : property.getEnds()) {
                Element owner;
                if (end.getOwner() == null || !(end.getOwner() instanceof Connector) || !((owner = ((Connector)end.getOwner()).getOwner()) instanceof Classifier)) continue;
                PropertyLinkedToClassifier link = new PropertyLinkedToClassifier((Classifier)owner, property);
                if (link.isLinkedWithMultiLevelPath()) {
                    ModelValidationHelper.createNestedConnectorEnd(end);
                    continue;
                }
                Stereotype appliedStereotype = end.getAppliedStereotype(NESTED_CONNECTOR_END_STEREOTYPE);
                if (appliedStereotype == null) continue;
                end.unapplyStereotype(appliedStereotype);
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateConnectorEnd(ConnectorEnd connectorEnd, IValidationContext ctx) {
        if (EMFEventType.SET.equals(ctx.getEventType()) && UMLPackage.eINSTANCE.getConnectorEnd_Role().equals(ctx.getFeature())) {
            ConnectableElement connectableElement = connectorEnd.getRole();
            Element connector = connectorEnd.getOwner();
            if (connector != null && connector.getOwner() instanceof Classifier) {
                Classifier owner = (Classifier)connector.getOwner();
                PropertyLinkedToClassifier link = new PropertyLinkedToClassifier(owner, (Property)connectableElement);
                if (link.isLinkedWithMultiLevelPath()) {
                    NestedConnectorEnd end = ModelValidationHelper.createNestedConnectorEnd(connectorEnd);
                    if (!link.getAvailableRoutes().isEmpty()) {
                        end.getPropertyPath().addAll(link.getAvailableRoutes().get(0).getProperties());
                    }
                } else {
                    Stereotype appliedStereotype = connectorEnd.getAppliedStereotype(NESTED_CONNECTOR_END_STEREOTYPE);
                    if (appliedStereotype != null) {
                        connectorEnd.unapplyStereotype(appliedStereotype);
                    }
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateNestedConnectorEnd(NestedConnectorEnd connectorEnd, IValidationContext ctx) {
        return ctx.createSuccessStatus();
    }

    private static NestedConnectorEnd createNestedConnectorEnd(ConnectorEnd connectorEnd) {
        NestedConnectorEnd nested = BlocksFactory.eINSTANCE.createNestedConnectorEnd();
        Resource res = ResourceUtil.getResource((EObject)connectorEnd);
        if (res != null) {
            res.getEobjects().add((Object)nested);
            nested.setBase_ConnectorEnd(connectorEnd);
        }
        return nested;
    }
}

