/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.helper.NotificationHelper;
import org.eclipse.papyrus.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.parts.ConstraintPropertyEditPart;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class SelfCompartmentNotificationHelper
extends NotificationHelper {
    private UIAdapter adapter = new UIAdapter();
    private final ConstraintPropertyEditPart compartmentPart;
    private final EStructuralFeature childFeature;
    private final IHintedType childType;
    private static CompositeTransactionalCommand command;

    public SelfCompartmentNotificationHelper(ConstraintPropertyEditPart compartmentPart, EStructuralFeature childFeature, IHintedType childType) {
        this.compartmentPart = compartmentPart;
        this.childFeature = childFeature;
        this.childType = childType;
        this.setModelListener(this.adapter);
    }

    public static void updatePropertiesParts(ConstraintPropertyEditPart compartmentPart, EStructuralFeature childFeature, IHintedType childType) {
        View compartmentView;
        EObject containerObject;
        if (compartmentPart == null || childFeature == null || childType == null) {
            return;
        }
        command = new CompositeTransactionalCommand(EditorUtils.getTransactionalEditingDomain(), "update children");
        command.setTransactionNestingEnabled(false);
        if (compartmentPart.getModel() instanceof View && (containerObject = (compartmentView = (View)compartmentPart.getModel()).getElement()) instanceof ConstraintProperty) {
            Property baseProperty = ((ConstraintProperty)containerObject).getBase_Property();
            if (baseProperty != null && baseProperty.getType() != null) {
                Object untypedOwnedObjects = baseProperty.getType().eGet(childFeature);
                if (untypedOwnedObjects instanceof List) {
                    List ownedEObjectChildren = (List)untypedOwnedObjects;
                    HashSet<EObject> drawnEObjectChildren = new HashSet<EObject>(ownedEObjectChildren.size());
                    Iterator iterator = compartmentView.getPersistedChildren().iterator();
                    while (iterator.hasNext()) {
                        EObject childView = (EObject)iterator.next();
                        if (!(childView instanceof View) || ((View)childView).getElement() == null) continue;
                        EObject child = ((View)childView).getElement();
                        switch (SysmlVisualIDRegistry.getVisualID((View)childView)) {
                            case 3002: {
                                if (ownedEObjectChildren.contains(child)) {
                                    drawnEObjectChildren.add(child);
                                    break;
                                }
                                SelfCompartmentNotificationHelper.deleteConnectorsViews((ICompositeCommand)command, (View)childView);
                                iterator.remove();
                                break;
                            }
                            case 2003: {
                                iterator.remove();
                                break;
                            }
                        }
                    }
                    ArrayList childrenToDraw = new ArrayList(ownedEObjectChildren);
                    childrenToDraw.removeAll(drawnEObjectChildren);
                    for (Object child : childrenToDraw) {
                        if (!(child instanceof EObject)) continue;
                        EObjectAdapter adapter = new EObjectAdapter((EObject)child);
                        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)adapter, Node.class, childType.getSemanticHint(), -1, false, compartmentPart.getDiagramPreferencesHint());
                        CreateCommand nodeCreationCommand = new CreateCommand(compartmentPart.getEditingDomain(), descriptor, compartmentView);
                        command.add((IUndoableOperation)nodeCreationCommand);
                    }
                }
            } else {
                Iterator iterator = compartmentView.getPersistedChildren().iterator();
                while (iterator.hasNext()) {
                    EObject childView = (EObject)iterator.next();
                    if (!(childView instanceof View) || SysmlVisualIDRegistry.getVisualID((View)childView) != 3002) continue;
                    SelfCompartmentNotificationHelper.deleteConnectorsViews((ICompositeCommand)command, (View)childView);
                    iterator.remove();
                }
            }
            SelfCompartmentNotificationHelper.execute();
        }
    }

    private static void execute() {
        if (!command.isEmpty()) {
            command.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
        }
    }

    private static void deleteConnectorsViews(ICompositeCommand cmd, View propertyView) {
        for (Edge incomingLink : propertyView.getTargetEdges()) {
            if (SysmlVisualIDRegistry.getVisualID((View)incomingLink) != 4001) continue;
            cmd.add((IUndoableOperation)new DeleteCommand((View)incomingLink));
        }
        for (Edge outgoingLink : propertyView.getSourceEdges()) {
            if (SysmlVisualIDRegistry.getVisualID((View)outgoingLink) != 4001) continue;
            cmd.add((IUndoableOperation)new DeleteCommand((View)outgoingLink));
        }
    }

    private class UIAdapter
    extends UIAdapterImpl {
        private UIAdapter() {
        }

        protected void safeNotifyChanged(Notification msg) {
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(msg.getFeature())) {
                SelfCompartmentNotificationHelper.this.listenObject((Notifier)msg.getNewValue());
                SelfCompartmentNotificationHelper.updatePropertiesParts(SelfCompartmentNotificationHelper.this.compartmentPart, SelfCompartmentNotificationHelper.this.childFeature, SelfCompartmentNotificationHelper.this.childType);
            } else if (UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().equals(msg.getFeature())) {
                SelfCompartmentNotificationHelper.updatePropertiesParts(SelfCompartmentNotificationHelper.this.compartmentPart, SelfCompartmentNotificationHelper.this.childFeature, SelfCompartmentNotificationHelper.this.childType);
            }
        }
    }
}

