/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.diagram.common.locator.AdvancedBorderItemLocator;

public class ParameterPositionLocator
extends AdvancedBorderItemLocator {
    public ParameterPositionLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public ParameterPositionLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public ParameterPositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        realLocation.height = realLocation.width = Math.max(realLocation.width, realLocation.height);
        int side = ParameterPositionLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
        this.setCurrentSideOfParent(ParameterPositionLocator.findClosestSideOfParent((Rectangle)borderItem.getBounds(), (Rectangle)this.getParentBorder()));
    }
}

