/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.sysml.diagram.parametric.navigator.SysmlAbstractNavigatorItem;
import org.eclipse.papyrus.sysml.diagram.parametric.navigator.SysmlNavigatorGroup;
import org.eclipse.papyrus.sysml.diagram.parametric.navigator.SysmlNavigatorItem;
import org.eclipse.papyrus.sysml.diagram.parametric.part.Messages;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class SysmlNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public SysmlNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (SysmlNavigatorContentProvider.this.myViewer != null) {
                    SysmlNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : SysmlNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (SysmlNavigatorContentProvider.this.myViewer != null) {
                    SysmlNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(SysmlNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : SysmlNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (SysmlNavigatorContentProvider.this.myViewer != null) {
                    SysmlNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(SysmlNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : SysmlNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (SysmlNavigatorContentProvider.this.myViewer != null) {
                    SysmlNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(SysmlNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    private Object[] getViewChildrenForParametricEditPart(View view, Object parentElement) {
        ArrayList<SysmlNavigatorGroup> result = new ArrayList<SysmlNavigatorGroup>();
        SysmlNavigatorGroup links = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Resource_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(2003));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(2005));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(4001));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        if (!links.isEmpty()) {
            result.add(links);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintPropertyEditPart(View view, Object parentElement) {
        ArrayList result = new ArrayList();
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(3002));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        return result.toArray();
    }

    private Object[] getViewChildrenForPropertyEditPart(View view, Object parentElement) {
        ArrayList<SysmlNavigatorGroup> result = new ArrayList<SysmlNavigatorGroup>();
        SysmlNavigatorGroup incominglinks = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Property_2005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        SysmlNavigatorGroup outgoinglinks = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Property_2005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForProperty2EditPart(View view, Object parentElement) {
        ArrayList<SysmlNavigatorGroup> result = new ArrayList<SysmlNavigatorGroup>();
        SysmlNavigatorGroup incominglinks = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Property_3002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        SysmlNavigatorGroup outgoinglinks = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Property_3002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConnectorEditPart(View view, Object parentElement) {
        ArrayList<SysmlNavigatorGroup> result = new ArrayList<SysmlNavigatorGroup>();
        SysmlNavigatorGroup target = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Connector_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        SysmlNavigatorGroup source = new SysmlNavigatorGroup(Messages.NavigatorGroupName_Connector_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(2005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(2005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), SysmlVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            return result.toArray();
        }
        if (parentElement instanceof SysmlNavigatorGroup) {
            SysmlNavigatorGroup group = (SysmlNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof SysmlNavigatorItem) {
            SysmlNavigatorItem navigatorItem = (SysmlNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 2003: {
                return this.getViewChildrenForConstraintPropertyEditPart(view, parentElement);
            }
            case 2005: {
                return this.getViewChildrenForPropertyEditPart(view, parentElement);
            }
            case 3002: {
                return this.getViewChildrenForProperty2EditPart(view, parentElement);
            }
            case 1000: {
                return this.getViewChildrenForParametricEditPart(view, parentElement);
            }
            case 4001: {
                return this.getViewChildrenForConnectorEditPart(view, parentElement);
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Parametric".equals(SysmlVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<SysmlNavigatorItem> result = new ArrayList<SysmlNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new SysmlNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof SysmlAbstractNavigatorItem) {
            SysmlAbstractNavigatorItem abstractNavigatorItem = (SysmlAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

