/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.papyrus.sysml.diagram.parametric.navigator.SysmlNavigatorGroup;
import org.eclipse.papyrus.sysml.diagram.parametric.navigator.SysmlNavigatorItem;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlElementTypes;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlParserProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class SysmlNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        SysmlDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        SysmlDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof SysmlNavigatorItem && !this.isOwnView(((SysmlNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof SysmlNavigatorGroup) {
            SysmlNavigatorGroup group = (SysmlNavigatorGroup)((Object)element);
            return SysmlDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof SysmlNavigatorItem) {
            SysmlNavigatorItem navigatorItem = (SysmlNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 2003: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/papyrus/0.7.0/SysML/Constraints?ConstraintProperty", SysmlElementTypes.ConstraintProperty_2003);
            }
            case 2005: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/uml2/3.0.0/UML?Property", SysmlElementTypes.Property_2005);
            }
            case 3002: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/3.0.0/UML?Property", SysmlElementTypes.Property_3002);
            }
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/papyurs/0.7.0/Resource?Resource", SysmlElementTypes.Resource_1000);
            }
            case 4001: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/3.0.0/UML?Connector", SysmlElementTypes.Connector_4001);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = SysmlDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && SysmlElementTypes.isKnownElementType(elementType)) {
            image = SysmlElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof SysmlNavigatorGroup) {
            SysmlNavigatorGroup group = (SysmlNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof SysmlNavigatorItem) {
            SysmlNavigatorItem navigatorItem = (SysmlNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 2003: {
                return this.getConstraintProperty_2003Text(view);
            }
            case 2005: {
                return this.getProperty_2005Text(view);
            }
            case 3002: {
                return this.getProperty_3002Text(view);
            }
            case 1000: {
                return this.getResource_1000Text(view);
            }
            case 4001: {
                return this.getConnector_4001Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getResource_1000Text(View view) {
        return "";
    }

    private String getConstraintProperty_2003Text(View view) {
        IParser parser = SysmlParserProvider.getParser(SysmlElementTypes.ConstraintProperty_2003, (EObject)(view.getElement() != null ? view.getElement() : view), SysmlVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SysmlDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getProperty_2005Text(View view) {
        IParser parser = SysmlParserProvider.getParser(SysmlElementTypes.Property_2005, (EObject)(view.getElement() != null ? view.getElement() : view), SysmlVisualIDRegistry.getType(5002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SysmlDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5002");
        return "";
    }

    private String getProperty_3002Text(View view) {
        IParser parser = SysmlParserProvider.getParser(SysmlElementTypes.Property_3002, (EObject)(view.getElement() != null ? view.getElement() : view), SysmlVisualIDRegistry.getType(5003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SysmlDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5003");
        return "";
    }

    private String getConnector_4001Text(View view) {
        IParser parser = SysmlParserProvider.getParser(SysmlElementTypes.Connector_4001, (EObject)(view.getElement() != null ? view.getElement() : view), SysmlVisualIDRegistry.getType(6001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SysmlDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6001");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "Parametric".equals(SysmlVisualIDRegistry.getModelID(view));
    }
}

