/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.parsers;

import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.sysml.diagram.parametric.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorLabelParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String TYPED_PARAMETER_FORMAT = "%s: %s";
    private static final String UNTYPED_PARAMETER_FORMAT = "%s";

    public ConnectorLabelParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public ConnectorLabelParser(EAttribute[] features) {
        super(features);
    }

    public ConnectorLabelParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        Connector connector = (Connector)obj;
        String name = connector.getName();
        if (name == null) {
            name = " ";
        }
        if (connector.getType() != null) {
            String type = connector.getType().getName();
            if (type == null) {
                type = "";
            }
            return String.format(TYPED_PARAMETER_FORMAT, name, type);
        }
        return String.format(UNTYPED_PARAMETER_FORMAT, name);
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        Connector connector = (Connector)element;
        semanticElementsBeingParsed.add(connector);
        if (connector.getType() != null) {
            semanticElementsBeingParsed.add(connector.getType());
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getConnector_Type().equals(feature);
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        return this.getEditorProcessor().format(this.getEditableValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }
}

