/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.parsers;

import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.sysml.diagram.parametric.parsers.MessageFormatParser;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.PropertyLinkedToClassifierNode;
import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLabelParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String UNTYPED_PARAMETER_FORMAT = "%s";
    private static final String TYPED_PARAMETER_FORMAT = "%s: %s";
    private static final String MULTIPLICITY_PARAMETER_FORMAT = "%s [%s..%s]";
    private static final String DEFAULT_VALUE_PARAMETER_FORMAT = "%s= %s";
    private static final String MODIFIER_PARAMETER_FORMAT = "%s{%s}";
    PropertyLinkedToClassifierNode propertyLinkedToClassifier;
    private Classifier classifier;

    public PropertyLabelParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public PropertyLabelParser(EAttribute[] features) {
        super(features);
    }

    public PropertyLabelParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String result = "";
        Property property = null;
        Object adapter = element.getAdapter(EObject.class);
        if (adapter instanceof Property) {
            EList redefinedProperties;
            ValueSpecification valueSpecification;
            String specificationValue;
            property = (Property)adapter;
            String name = property.isDerived() ? "/ " + property.getName() : property.getName();
            result = String.format(UNTYPED_PARAMETER_FORMAT, name);
            for (Object obj : DiagramEditPartsUtil.getEObjectViews((EObject)property)) {
                if (!(obj instanceof Node) || this.classifier == null) continue;
                this.propertyLinkedToClassifier = new PropertyLinkedToClassifierNode(this.classifier, property, (Node)obj);
                this.propertyLinkedToClassifier.refresh();
                name = this.propertyLinkedToClassifier.getName();
                result = String.format(UNTYPED_PARAMETER_FORMAT, name);
            }
            if (property.getType() != null) {
                String type = property.getType().getName();
                result = String.format(TYPED_PARAMETER_FORMAT, name, type);
            }
            if (property.getLower() != 1 || property.getUpper() != 1) {
                result = String.format(MULTIPLICITY_PARAMETER_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getLowerValue()), ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getUpperValue()));
            }
            if (property.getDefaultValue() != null && (specificationValue = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)(valueSpecification = property.getDefaultValue()))) != null && specificationValue.length() > 0) {
                result = String.format(DEFAULT_VALUE_PARAMETER_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
            }
            StringBuffer sb = new StringBuffer();
            if (property.isReadOnly()) {
                sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
            }
            if (property.isOrdered()) {
                sb.append(sb.length() == 0 ? "ordered" : ", ordered");
            }
            if (property.isUnique()) {
                sb.append(sb.length() == 0 ? "unique" : ", unique");
            }
            if (property.isDerivedUnion()) {
                sb.append(sb.length() == 0 ? "union" : ", union");
            }
            if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                for (Property p : redefinedProperties) {
                    sb.append(sb.length() == 0 ? p.getName() : ", redefines " + p.getName());
                }
            }
            if (sb.length() != 0) {
                result = String.format(MODIFIER_PARAMETER_FORMAT, result, sb.toString());
            }
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        Property property = null;
        if (element instanceof Property) {
            property = (Property)element;
            semanticElementsBeingParsed.add(property);
            if (property.getType() != null) {
                semanticElementsBeingParsed.add(property.getType());
            }
            if (property.getLowerValue() != null) {
                semanticElementsBeingParsed.add(property.getLowerValue());
            }
            if (property.getUpperValue() != null) {
                semanticElementsBeingParsed.add(property.getUpperValue());
            }
            if (property.getDefaultValue() != null) {
                semanticElementsBeingParsed.add(property.getDefaultValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getConnector_Type().equals(feature) || UMLPackage.eINSTANCE.getInstanceValue_Instance().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature) || UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly().equals(feature) || UMLPackage.eINSTANCE.getFeature_IsStatic().equals(feature) || UMLPackage.eINSTANCE.getProperty_IsDerived().equals(feature) || UMLPackage.eINSTANCE.getProperty_IsDerivedUnion().equals(feature) || UMLPackage.eINSTANCE.getProperty_RedefinedProperty().equals(feature);
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        return this.getEditorProcessor().format(this.getEditableValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public void setBlock(EObject element) {
        if (element instanceof Classifier) {
            this.classifier = (Classifier)element;
        }
    }
}

