/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.sysml.diagram.parametric.part.Messages;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlCreationWizardPage;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SysmlCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SysmlCreationWizardPage diagramModelFilePage;
    protected SysmlCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.SysmlCreationWizardTitle);
        this.setDefaultPageImageDescriptor(SysmlDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewResourceWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new SysmlCreationWizardPage("DiagramModelFile", this.getSelection(), "sysml_diagram");
        this.diagramModelFilePage.setTitle(Messages.SysmlCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.SysmlCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new SysmlCreationWizardPage("DomainModelFile", this.getSelection(), "sysml"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = SysmlCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".sysml_diagram".length());
                    this.setFileName(SysmlDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "sysml"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.SysmlCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.SysmlCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                SysmlCreationWizard.this.diagram = SysmlDiagramEditorUtil.createDiagram(SysmlCreationWizard.this.diagramModelFilePage.getURI(), SysmlCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (SysmlCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && SysmlCreationWizard.this.diagram != null) {
                    try {
                        SysmlDiagramEditorUtil.openDiagram(SysmlCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)SysmlCreationWizard.this.getContainer().getShell(), (String)Messages.SysmlCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SysmlCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SysmlDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

