/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.part;

import java.util.EventObject;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDragSourceListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.core.adaptor.gmf.GmfMultiDiagramDocumentProvider;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.diagram.common.listeners.DropTargetListener;
import org.eclipse.papyrus.diagram.common.part.PapyrusPaletteContextMenuProvider;
import org.eclipse.papyrus.diagram.common.part.PapyrusPaletteViewer;
import org.eclipse.papyrus.diagram.common.part.UmlGmfDiagramEditor;
import org.eclipse.papyrus.diagram.common.service.PapyrusPaletteService;
import org.eclipse.papyrus.sysml.diagram.parametric.navigator.SysmlNavigatorItem;
import org.eclipse.papyrus.sysml.diagram.parametric.part.DiagramEditorContextMenuProvider;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class SysmlDiagramEditor
extends UmlGmfDiagramEditor
implements IProviderChangeListener,
IGotoMarker {
    public static final String ID = "org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorID";
    public static final String CONTEXT_ID = "org.eclipse.papyrus.sysml.diagram.parametric.ui.diagramContext";
    private KeyHandler paletteKeyHandler = null;
    private MouseListener paletteMouseListener = null;
    private IUndoableOperation savedOperation = null;
    private TransactionalEditingDomain editingDomain;
    private IDocumentProvider documentProvider;

    public SysmlDiagramEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws ServiceException {
        super(servicesRegistry, diagram);
        PapyrusPaletteService.getInstance().addProviderChangeListener((IProviderChangeListener)this);
        this.editingDomain = (TransactionalEditingDomain)servicesRegistry.getService(TransactionalEditingDomain.class);
        this.documentProvider = new GmfMultiDiagramDocumentProvider(this.editingDomain);
        this.setDocumentProvider(this.documentProvider);
    }

    protected String getContextID() {
        return CONTEXT_ID;
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot paletteRoot;
        if (existingPaletteRoot == null) {
            paletteRoot = PapyrusPaletteService.getInstance().createPalette((IEditorPart)this, this.getDefaultPaletteContent());
        } else {
            PapyrusPaletteService.getInstance().updatePalette(existingPaletteRoot, (IEditorPart)this, this.getDefaultPaletteContent());
            paletteRoot = existingPaletteRoot;
        }
        this.applyCustomizationsToPalette(paletteRoot);
        return paletteRoot;
    }

    protected PreferencesHint getPreferencesHint() {
        return SysmlDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    public String getContributorId() {
        return "org.eclipse.papyrus.sysml.diagram.parametric";
    }

    public Object getAdapter(Class type) {
        if (type == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
                }
            };
        }
        return super.getAdapter(type);
    }

    protected final IDocumentProvider getDocumentProvider(IEditorInput input) {
        return this.documentProvider;
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler keyHandler = new KeyHandler();
        return keyHandler;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected final void setDocumentProvider(IEditorInput input) {
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), this.getNavigatorSelection());
    }

    private ISelection getNavigatorSelection() {
        IDiagramDocument document = this.getDiagramDocument();
        if (document == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = document.getDiagram();
        if (diagram == null || diagram.eResource() == null) {
            return StructuredSelection.EMPTY;
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (file != null) {
            SysmlNavigatorItem item = new SysmlNavigatorItem((View)diagram, file, false);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        DiagramEditorContextMenuProvider provider = new DiagramEditorContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
        this.getDiagramGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)this.getDiagramGraphicalViewer());
    }

    protected TransactionalEditingDomain createEditingDomain() {
        return this.editingDomain;
    }

    protected void configureDiagramEditDomain() {
        super.configureDiagramEditDomain();
        this.getDiagramEditDomain().getDiagramCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                SysmlDiagramEditor.this.firePropertyChange(257);
            }
        });
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.savedOperation = this.getOperationHistory().getUndoOperation(this.getUndoContext());
    }

    public boolean isDirty() {
        IUndoableOperation op = this.getOperationHistory().getUndoOperation(this.getUndoContext());
        return this.savedOperation != op;
    }

    public void providerChanged(ProviderChangeEvent event) {
        if (PapyrusPaletteService.getInstance().equals(event.getSource())) {
            PapyrusPaletteService.getInstance().updatePalette(this.getPaletteViewer().getPaletteRoot(), (IEditorPart)this, this.getDefaultPaletteContent());
        }
    }

    public void dispose() {
        PapyrusPaletteService.getInstance().removeProviderChangeListener((IProviderChangeListener)this);
        super.dispose();
    }

    protected PaletteViewer getPaletteViewer() {
        return this.getEditDomain().getPaletteViewer();
    }

    protected PaletteViewer constructPaletteViewer() {
        return new PapyrusPaletteViewer();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        this.getEditDomain().setPaletteRoot(this.createPaletteRoot(null));
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setContextMenu((MenuManager)new PapyrusPaletteContextMenuProvider(viewer));
                viewer.getKeyHandler().setParent(this.getPaletteKeyHandler());
                viewer.getControl().addMouseListener(this.getPaletteMouseListener());
                viewer.addDragSourceListener((TransferDragSourceListener)new PaletteToolTransferDragSourceListener((EditPartViewer)viewer));
                viewer.setCustomizer(SysmlDiagramEditor.this.createPaletteCustomizer());
            }

            public PaletteViewer createPaletteViewer(Composite parent) {
                PaletteViewer pViewer = SysmlDiagramEditor.this.constructPaletteViewer();
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }

            private KeyHandler getPaletteKeyHandler() {
                if (SysmlDiagramEditor.this.paletteKeyHandler == null) {
                    SysmlDiagramEditor.this.paletteKeyHandler = new KeyHandler(){

                        public boolean keyReleased(KeyEvent event) {
                            if (event.keyCode == 13) {
                                Tool tool = SysmlDiagramEditor.this.getPaletteViewer().getActiveTool().createTool();
                                if (SysmlDiagramEditor.this.toolSupportsAccessibility(tool)) {
                                    tool.keyUp(event, (EditPartViewer)SysmlDiagramEditor.this.getDiagramGraphicalViewer());
                                    SysmlDiagramEditor.this.getPaletteViewer().setActiveTool(null);
                                    return true;
                                }
                            }
                            return super.keyReleased(event);
                        }
                    };
                }
                return SysmlDiagramEditor.this.paletteKeyHandler;
            }

            private MouseListener getPaletteMouseListener() {
                if (SysmlDiagramEditor.this.paletteMouseListener == null) {
                    SysmlDiagramEditor.this.paletteMouseListener = new MouseListener(){
                        private boolean clearActiveTool = false;

                        public void mouseDoubleClick(MouseEvent e) {
                            Tool tool = SysmlDiagramEditor.this.getPaletteViewer().getActiveTool().createTool();
                            if (SysmlDiagramEditor.this.toolSupportsAccessibility(tool)) {
                                tool.setViewer((EditPartViewer)SysmlDiagramEditor.this.getDiagramGraphicalViewer());
                                tool.setEditDomain(SysmlDiagramEditor.this.getDiagramGraphicalViewer().getEditDomain());
                                tool.mouseDoubleClick(e, (EditPartViewer)SysmlDiagramEditor.this.getDiagramGraphicalViewer());
                                this.clearActiveTool = true;
                            }
                        }

                        public void mouseDown(MouseEvent e) {
                        }

                        public void mouseUp(MouseEvent e) {
                            if (this.clearActiveTool) {
                                SysmlDiagramEditor.this.getPaletteViewer().setActiveTool(null);
                                this.clearActiveTool = false;
                            }
                        }
                    };
                }
                return SysmlDiagramEditor.this.paletteMouseListener;
            }
        };
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalSelectionTransfer.getTransfer()){

            protected Object getJavaObject(TransferData data) {
                return LocalSelectionTransfer.getTransfer().nativeToJava(data);
            }

            protected TransactionalEditingDomain getTransactionalEditingDomain() {
                return SysmlDiagramEditor.this.getEditingDomain();
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getSite().getPage().getActiveEditor() instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)this.getSite().getPage().getActiveEditor();
            if (((Object)((Object)this)).equals(editor.getActiveEditor())) {
                this.updateActions(this.getSelectionActions());
                super.selectionChanged(part, selection);
            } else {
                super.selectionChanged(part, selection);
            }
        } else {
            super.selectionChanged(part, selection);
        }
        if (part == this) {
            this.rebuildStatusLine();
        }
    }
}

