/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.part;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.resource.util.ResourceUtil;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlLinkDescriptor;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlNodeDescriptor;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlElementTypes;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysmlDiagramUpdater {
    public static List<SysmlNodeDescriptor> getSemanticChildren(View view) {
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return SysmlDiagramUpdater.getResource_1000SemanticChildren(view);
            }
            case 2003: {
                return SysmlDiagramUpdater.getConstraintProperty_2003SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    public static List getConstraintProperty_2003SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        ConstraintProperty modelElement = (ConstraintProperty)view.getElement();
        LinkedList<SysmlNodeDescriptor> result = new LinkedList<SysmlNodeDescriptor>();
        Property childElement = modelElement.getBase_Property();
        int visualID = SysmlVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
        if (visualID == 3002) {
            result.add(new SysmlNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List getResource_1000SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SysmlNodeDescriptor> result = new LinkedList<SysmlNodeDescriptor>();
        EObject eObject = view.getElement();
        if (eObject instanceof Class) {
            Class modelElement = (Class)eObject;
            EList eobjects = ResourceUtil.getResource((EObject)modelElement).getEobjects();
            for (EObject childElement : eobjects) {
                int visualID = SysmlVisualIDRegistry.getNodeVisualID(view, childElement);
                if (visualID != 2003) continue;
                result.add(new SysmlNodeDescriptor(childElement, visualID));
            }
            for (EObject obj : modelElement.getOwnedAttributes()) {
                Property childElement;
                int visualID;
                if (!(obj instanceof Property) || (visualID = SysmlVisualIDRegistry.getNodeVisualID(view, (EObject)(childElement = (Property)obj))) != 2005 || childElement.getAppliedStereotype("SysML::Constraints::ConstraintProperty") != null) continue;
                result.add(new SysmlNodeDescriptor((EObject)childElement, visualID));
            }
        }
        return result;
    }

    public static List<SysmlLinkDescriptor> getContainedLinks(View view) {
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return SysmlDiagramUpdater.getResource_1000ContainedLinks(view);
            }
            case 2003: {
                return SysmlDiagramUpdater.getConstraintProperty_2003ContainedLinks(view);
            }
            case 2005: {
                return SysmlDiagramUpdater.getProperty_2005ContainedLinks(view);
            }
            case 3002: {
                return SysmlDiagramUpdater.getProperty_3002ContainedLinks(view);
            }
            case 4001: {
                return SysmlDiagramUpdater.getConnector_4001ContainedLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getIncomingLinks(View view) {
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 2003: {
                return SysmlDiagramUpdater.getConstraintProperty_2003IncomingLinks(view);
            }
            case 2005: {
                return SysmlDiagramUpdater.getProperty_2005IncomingLinks(view);
            }
            case 3002: {
                return SysmlDiagramUpdater.getProperty_3002IncomingLinks(view);
            }
            case 4001: {
                return SysmlDiagramUpdater.getConnector_4001IncomingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getOutgoingLinks(View view) {
        switch (SysmlVisualIDRegistry.getVisualID(view)) {
            case 2003: {
                return SysmlDiagramUpdater.getConstraintProperty_2003OutgoingLinks(view);
            }
            case 2005: {
                return SysmlDiagramUpdater.getProperty_2005OutgoingLinks(view);
            }
            case 3002: {
                return SysmlDiagramUpdater.getProperty_3002OutgoingLinks(view);
            }
            case 4001: {
                return SysmlDiagramUpdater.getConnector_4001OutgoingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getResource_1000ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getConstraintProperty_2003ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getProperty_2005ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getProperty_3002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getConnector_4001ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getConstraintProperty_2003IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getProperty_2005IncomingLinks(View view) {
        Property modelElement = (Property)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<SysmlLinkDescriptor> result = new LinkedList<SysmlLinkDescriptor>();
        result.addAll(SysmlDiagramUpdater.getIncomingTypeModelFacetLinks_Connector_4001((ConnectableElement)modelElement, crossReferences));
        return result;
    }

    public static List<SysmlLinkDescriptor> getProperty_3002IncomingLinks(View view) {
        Property modelElement = (Property)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<SysmlLinkDescriptor> result = new LinkedList<SysmlLinkDescriptor>();
        result.addAll(SysmlDiagramUpdater.getIncomingTypeModelFacetLinks_Connector_4001((ConnectableElement)modelElement, crossReferences));
        return result;
    }

    public static List<SysmlLinkDescriptor> getConnector_4001IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getConstraintProperty_2003OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<SysmlLinkDescriptor> getProperty_2005OutgoingLinks(View view) {
        Property modelElement = (Property)view.getElement();
        LinkedList<SysmlLinkDescriptor> result = new LinkedList<SysmlLinkDescriptor>();
        result.addAll(SysmlDiagramUpdater.getOutgoingTypeModelFacetLinks_Connector_4001((ConnectableElement)modelElement));
        return result;
    }

    public static List<SysmlLinkDescriptor> getProperty_3002OutgoingLinks(View view) {
        Property modelElement = (Property)view.getElement();
        LinkedList<SysmlLinkDescriptor> result = new LinkedList<SysmlLinkDescriptor>();
        result.addAll(SysmlDiagramUpdater.getOutgoingTypeModelFacetLinks_Connector_4001((ConnectableElement)modelElement));
        return result;
    }

    public static List<SysmlLinkDescriptor> getConnector_4001OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    private static Collection getIncomingTypeModelFacetLinks_Connector_4001(ConnectableElement target, Map crossReferences) {
        LinkedList<SysmlLinkDescriptor> result = new LinkedList<SysmlLinkDescriptor>();
        Collection settings = (Collection)crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            ConnectorEnd connectorEnd;
            Connector link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getConnectorEnd_Role() || !(setting.getEObject() instanceof ConnectorEnd) || 4001 != SysmlVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Connector)(connectorEnd = (ConnectorEnd)setting.getEObject()).getOwner()))) continue;
            ConnectableElement src = null;
            EList ends = link.getEnds();
            if (ends != null && !ends.isEmpty()) {
                src = ((ConnectorEnd)ends.get(0)).getRole();
            }
            result.add(new SysmlLinkDescriptor((EObject)src, (EObject)target, (EObject)link, SysmlElementTypes.Connector_4001, 4001));
        }
        return result;
    }

    private static Collection getOutgoingTypeModelFacetLinks_Connector_4001(ConnectableElement source) {
        StructuredClassifier container = null;
        ConnectableElement element = source;
        while (element != null && container == null) {
            if (element instanceof StructuredClassifier) {
                container = (StructuredClassifier)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SysmlLinkDescriptor> result = new LinkedList<SysmlLinkDescriptor>();
        for (EObject linkObject : container.getOwnedConnectors()) {
            Connector link;
            if (!(linkObject instanceof Connector) || 4001 != SysmlVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Connector)linkObject))) continue;
            ConnectableElement src = null;
            ConnectableElement dst = null;
            EList ends = link.getEnds();
            if (ends != null && !ends.isEmpty() && ends.size() > 1) {
                src = ((ConnectorEnd)ends.get(0)).getRole();
                dst = ((ConnectorEnd)ends.get(1)).getRole();
            }
            if (src != source) continue;
            result.add(new SysmlLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, SysmlElementTypes.Connector_4001, 4001));
        }
        return result;
    }
}

