/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.resource.Resource;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.uml2.uml.UMLPackage;

public class SysmlVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.sysml.diagram.parametric/debug/visualID";
    private static ViewInfo diagramViewInfo = null;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Parametric".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return SysmlVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                SysmlDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getClass_().equals(domainElement.eClass())) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SysmlVisualIDRegistry.getModelID(containerView);
        if (!"Parametric".equals(containerModelID)) {
            return -1;
        }
        if ("Parametric".equals(containerModelID)) {
            containerVisualID = SysmlVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (ConstraintsPackage.eINSTANCE.getConstraintProperty().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 2005;
            }
            case 2003: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SysmlVisualIDRegistry.getModelID(containerView);
        if (!"Parametric".equals(containerModelID)) {
            return false;
        }
        if ("Parametric".equals(containerModelID)) {
            containerVisualID = SysmlVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2005 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(Resource element) {
        return true;
    }

    public static ViewInfo getDiagramViewInfo() {
        if (diagramViewInfo == null) {
            diagramViewInfo = SysmlVisualIDRegistry.getResource_1000ViewInfo();
        }
        return diagramViewInfo;
    }

    protected static ViewInfo getResource_1000ViewInfo() {
        BaseViewInfo root = new BaseViewInfo(1000, 0, "", null, null);
        BaseViewInfo viewInfo = null;
        BaseViewInfo labelInfo = null;
        viewInfo = new BaseViewInfo(2003, 2, "ConstraintProperty");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2005, 2, "Property");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4001, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6001, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(3002, 2, "Property");
        root.addNode(2003, (ViewInfo)viewInfo);
        return root;
    }
}

