/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.resource.ResourcePackage;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.UMLPackage;

public class SysmlElementTypes {
    private static Map<IElementType, ENamedElement> elements;
    private static ImageRegistry imageRegistry;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType Resource_1000;
    public static final IElementType ConstraintProperty_2003;
    public static final IElementType Property_2005;
    public static final IElementType Property_3002;
    public static final IElementType Connector_4001;

    static {
        Resource_1000 = SysmlElementTypes.getElementType("org.eclipse.papyrus.sysml.diagram.parametric.Resource_1000");
        ConstraintProperty_2003 = SysmlElementTypes.getElementType("org.eclipse.papyrus.sysml.diagram.parametric.ConstraintProperty_2003");
        Property_2005 = SysmlElementTypes.getElementType("org.eclipse.papyrus.sysml.diagram.parametric.Property_2005");
        Property_3002 = SysmlElementTypes.getElementType("org.eclipse.papyrus.sysml.diagram.parametric.Property_3002");
        Connector_4001 = SysmlElementTypes.getElementType("org.eclipse.papyrus.sysml.diagram.parametric.Connector_4001");
    }

    private SysmlElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return SysmlDiagramEditorPlugin.getInstance().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = SysmlElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = SysmlElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = SysmlElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            SysmlElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = SysmlElementTypes.getImageRegistryKey(element);
        Image image = SysmlElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = SysmlElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            SysmlElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = SysmlElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        ENamedElement element = SysmlElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return SysmlElementTypes.getImageDescriptor(element);
    }

    public static Image getImage(IAdaptable hint) {
        ENamedElement element = SysmlElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return SysmlElementTypes.getImage(element);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, ENamedElement>();
            elements.put(Resource_1000, (ENamedElement)ResourcePackage.eINSTANCE.getResource());
            elements.put(ConstraintProperty_2003, (ENamedElement)ConstraintsPackage.eINSTANCE.getConstraintProperty());
            elements.put(Property_2005, (ENamedElement)UMLPackage.eINSTANCE.getProperty());
            elements.put(Property_3002, (ENamedElement)UMLPackage.eINSTANCE.getProperty());
            elements.put(Connector_4001, (ENamedElement)UMLPackage.eINSTANCE.getConnector());
        }
        return elements.get(type);
    }

    private static IElementType getElementType(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(Resource_1000);
            KNOWN_ELEMENT_TYPES.add(ConstraintProperty_2003);
            KNOWN_ELEMENT_TYPES.add(Property_2005);
            KNOWN_ELEMENT_TYPES.add(Property_3002);
            KNOWN_ELEMENT_TYPES.add(Connector_4001);
        }
        return KNOWN_ELEMENT_TYPES.contains(elementType);
    }

    public static IElementType getElementType(int visualID) {
        switch (visualID) {
            case 1000: {
                return Resource_1000;
            }
            case 2003: {
                return ConstraintProperty_2003;
            }
            case 2005: {
                return Property_2005;
            }
            case 3002: {
                return Property_3002;
            }
            case 4001: {
                return Connector_4001;
            }
        }
        return null;
    }
}

