/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.providers;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.diagram.parametric.helper.ModelValidationHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;

public class SysmlValidationProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        Runnable op = operation;
        Runnable task = new Runnable(){

            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                SysmlDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (SysmlValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "Parametric".equals(SysmlVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }

    static String formatElement(EObject object) {
        return EMFCoreUtil.getQualifiedName((EObject)object, (boolean)true);
    }

    public static class Adapter1
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            Connector context = (Connector)ctx.getTarget();
            return ModelValidationHelper.validateConnector(context, ctx);
        }
    }

    public static class Adapter2
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            Property context = (Property)ctx.getTarget();
            return ModelValidationHelper.validateProperty(context, ctx);
        }
    }

    public static class Adapter3
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            ConnectorEnd context = (ConnectorEnd)ctx.getTarget();
            return ModelValidationHelper.validateConnectorEnd(context, ctx);
        }
    }

    public static class Adapter4
    extends AbstractModelConstraint {
        public IStatus validate(IValidationContext ctx) {
            NestedConnectorEnd context = (NestedConnectorEnd)ctx.getTarget();
            return ModelValidationHelper.validateNestedConnectorEnd(context, ctx);
        }
    }

    public static class DefaultCtx
    implements IClientSelector {
        public boolean selects(Object object) {
            return SysmlValidationProvider.isInDefaultEditorContext(object);
        }
    }
}

