/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlVisualIDRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.providers.SysmlElementTypes;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class SysmlViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = SysmlVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        int visualID = SysmlVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return SysmlVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "Parametric";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "Parametric".equals(op.getSemanticHint()) && SysmlVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = SysmlVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = SysmlVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (!SysmlElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != SysmlVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"Parametric".equals(SysmlVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 2003: 
                    case 2005: 
                    case 3002: {
                        if (domainElement != null && visualID == SysmlVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2003 == visualID || 2005 == visualID || 3002 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!SysmlElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = SysmlVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == SysmlVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("Parametric");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? SysmlVisualIDRegistry.getNodeVisualID(containerView, domainElement) : SysmlVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2003: {
                return this.createConstraintProperty_2003(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2005: {
                return this.createProperty_2005(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3002: {
                return this.createProperty_3002(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (SysmlVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 4001: {
                return this.createConnector_4001(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createConstraintProperty_2003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SysmlVisualIDRegistry.getType(2003));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        this.initForegroundFromPrefs((View)node, prefStore, "ConstraintProperty");
        this.initFontStyleFromPrefs((View)node, prefStore, "ConstraintProperty");
        this.initBackgroundFromPrefs((View)node, prefStore, "ConstraintProperty");
        Node label5001 = this.createLabel((View)node, SysmlVisualIDRegistry.getType(5001));
        Node label5004 = this.createLabel((View)node, SysmlVisualIDRegistry.getType(5004));
        Type type = ((ConstraintProperty)domainElement).getBase_Property().getType();
        if (type != null && type instanceof StructuredClassifier) {
            for (Property property : ((StructuredClassifier)type).getOwnedAttributes()) {
                this.createProperty_3002((EObject)property, (View)node, index, persisted, preferencesHint);
            }
        }
        return node;
    }

    public Node createProperty_2005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SysmlVisualIDRegistry.getType(2005));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        Node label5002 = this.createLabel((View)node, SysmlVisualIDRegistry.getType(5002));
        return node;
    }

    public Node createProperty_3002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createHintedDiagramLinkStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SysmlVisualIDRegistry.getType(3002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        PreferenceInitializerForElementHelper.initBackgroundFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        Node label5003 = this.createLabel((View)node, SysmlVisualIDRegistry.getType(5003));
        label5003.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5003 = (Location)label5003.getLayoutConstraint();
        location5003.setX(0);
        location5003.setY(5);
        return node;
    }

    public Edge createConnector_4001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(SysmlVisualIDRegistry.getType(4001));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initForegroundFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Connector");
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Connector");
        PreferenceInitializerForElementHelper.initRountingFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Connector");
        Node label6001 = this.createLabel((View)edge, SysmlVisualIDRegistry.getType(6001));
        label6001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6001 = (Location)label6001.getLayoutConstraint();
        location6001.setX(0);
        location6001.setY(40);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Connector");
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"Parametric".equals(SysmlVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"Parametric");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private void initFontStyleFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fontConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)1);
        String fontColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)2);
        FontStyle viewFontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (viewFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontConstant);
            viewFontStyle.setFontName(fontData.getName());
            viewFontStyle.setFontHeight(fontData.getHeight());
            viewFontStyle.setBold((fontData.getStyle() & 1) != 0);
            viewFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fontColorConstant);
            viewFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    private void initForegroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String lineColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)3);
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)lineColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
    }

    private void initBackgroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fillColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)0);
        String gradientColorConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)4);
        String gradientPolicyConstant = PreferenceConstantHelper.getElementConstant((String)elementName, (int)5);
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fillColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
        fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        if (store.getBoolean(gradientPolicyConstant)) {
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(gradientColorConstant));
            fillStyle.setGradient(gradientPreferenceConverter.getGradientData());
            fillStyle.setTransparency(gradientPreferenceConverter.getTransparency());
        }
    }
}

