/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.texteditor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.parsers.modelgenerator.PropertyGenerator;
import org.eclipse.papyrus.parsers.texteditor.CompletionFilterSourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyConfigurationForUML;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyLabelSourceViewerConfiguration;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.umlutils.PropertyUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class ConstraintPropertyConfiguration
extends DefaultDirectEditorConfiguration {
    private final PropertyLabelSourceViewerConfiguration configuration = new PropertyLabelSourceViewerConfiguration(new CompletionFilterSourceViewerConfiguration.ICompletionFilter(){

        public boolean filter(int context, EObject e) {
            switch (context) {
                case 4: {
                    return !(e instanceof Element) || ((Element)e).getAppliedStereotype("SysML::Constraints::ConstraintBlock") == null;
                }
            }
            return false;
        }
    });

    public SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.configuration;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof ConstraintProperty) {
            Property property = ((ConstraintProperty)editedObject).getBase_Property();
            return PropertyUtil.getLabel((Property)property);
        }
        return "not a Constraint Property";
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof ConstraintProperty) {
            Property property = ((ConstraintProperty)objectToEdit).getBase_Property();
            this.configuration.setProperty(property);
        }
        return super.preEditAction(objectToEdit);
    }

    public Object postEditAction(Object editedObject, String text) {
        if (editedObject instanceof ConstraintProperty) {
            Property property = ((ConstraintProperty)editedObject).getBase_Property();
            PropertyGenerator generator = new PropertyGenerator(property);
            generator.parseAndModifyProperty(text);
        }
        return null;
    }

    public IInputValidator getInputValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (ConstraintPropertyConfiguration.this.getObjectToEdit() instanceof ConstraintProperty) {
                    Property property = ((ConstraintProperty)ConstraintPropertyConfiguration.this.getObjectToEdit()).getBase_Property();
                    PropertyGenerator generator = new PropertyGenerator(property);
                    return generator.parseAndValidateProperty(newText);
                }
                return null;
            }
        };
    }

    public IDirectEditorConfiguration.Selection getTextSelection(String value, Object editedObject) {
        if (editedObject instanceof ConstraintProperty) {
            Property property = ((ConstraintProperty)editedObject).getBase_Property();
            return new PropertyConfigurationForUML().getTextSelection(value, (Object)property);
        }
        return super.getTextSelection(value, editedObject);
    }
}

