/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.utils;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.Route;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLinkedToClassifier {
    private final Classifier classifier;
    private final Property property;
    private List<Route> routes;

    public PropertyLinkedToClassifier(Classifier classifier, Property property) {
        this.classifier = classifier;
        this.property = property;
        this.routes = new LinkedList<Route>();
        this.refresh();
    }

    public boolean isLinkedToClassifier() {
        return !this.routes.isEmpty();
    }

    public boolean isLinkedWithMultiLevelPath() {
        boolean result = false;
        if (!this.routes.isEmpty()) {
            for (Route r : this.routes) {
                result |= r.getRouteDepth() > 1;
            }
        }
        return result;
    }

    public List<Route> getAvailableRoutes() {
        return this.routes;
    }

    protected Property getProperty() {
        return this.property;
    }

    public int getNumberAvailableRoute() {
        return this.routes.size();
    }

    private void refreshLinkToClassifier(Classifier classifierParent, Property propertyToFind, Route route) {
        EList classifierParentAttributes = classifierParent.getAllAttributes();
        if (classifierParentAttributes.contains((Object)propertyToFind)) {
            route.addSegment(propertyToFind);
            this.routes.add(route);
        } else {
            for (Property attribute : classifierParentAttributes) {
                if (attribute instanceof Port) continue;
                Type attributeType = attribute.getType();
                if (route.getProperties().contains(attribute)) break;
                if (!(attributeType instanceof Classifier)) continue;
                Route newRoute = new Route(new LinkedList<Property>(route.getProperties()));
                newRoute.addSegment(attribute);
                this.refreshLinkToClassifier((Classifier)attributeType, propertyToFind, newRoute);
            }
        }
    }

    public boolean hasSeveralRoutes() {
        return this.routes.size() > 1;
    }

    public void refresh() {
        this.routes.clear();
        this.refreshLinkToClassifier(this.classifier, this.property, new Route());
    }
}

