/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.sysml.diagram.parametric.part.SysmlDiagramEditorPlugin;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.PropertyLinkedToClassifier;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.Route;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLinkedToClassifierNode
extends PropertyLinkedToClassifier {
    public static final String PROPERTY_ROUTE_URL_SOURCE = "http://www.eclipse.org/papyrus/propertyRoute";
    public static final String SELECTED_ROUTE_KEY = "selectedRoute";
    private Node graphNode;

    public PropertyLinkedToClassifierNode(Classifier classifier, Property property, Node graphNode) {
        super(classifier, property);
        this.graphNode = graphNode;
    }

    public String getName() {
        String lName = "";
        lName = this.getAvailableRoutes().isEmpty() ? this.getProperty().getName() : (!this.hasSeveralRoutes() ? this.getAvailableRoutes().get(0).getName() : this.getSelectedRoute());
        return lName;
    }

    private String getSelectedRoute() {
        String result = "";
        if ("".equals(this.getRootingProperty(this.graphNode))) {
            LinkedList<Route> filteredAvailableRoute = this.filterAvailableRoute(this.getAvailableRoutes());
            if (filteredAvailableRoute.size() == 1) {
                result = filteredAvailableRoute.getFirst().getName();
            } else if (!filteredAvailableRoute.isEmpty()) {
                result = filteredAvailableRoute.getFirst().getName();
            }
        } else {
            String oldRouteSelectedValue = this.getRootingProperty(this.graphNode);
            Map<String, Route> routeNameAndRoute = this.getRouteNameAndRoute(this.getAvailableRoutes());
            result = routeNameAndRoute.containsKey(oldRouteSelectedValue) ? oldRouteSelectedValue : this.calculateNewRoute(oldRouteSelectedValue);
        }
        return result;
    }

    private String getUserSelectionRoute(LinkedList<Route> filteredAvailableRoute) {
        IWorkbench workBench = SysmlDiagramEditorPlugin.getInstance().getWorkbench();
        Shell shell = workBench.getActiveWorkbenchWindow().getShell();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new CreateOrSelectElementCommand.LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Route) {
                    return ((Route)element).getName();
                }
                return super.getText(element);
            }
        });
        dialog.setTitle("Routing selection");
        dialog.setMessage("Select the route of the property (* = any string, ? = any char):");
        dialog.setElements(filteredAvailableRoute.toArray());
        dialog.setHelpAvailable(false);
        dialog.setMultipleSelection(false);
        dialog.open();
        String result = "";
        result = dialog.getResult() != null ? ((Route)dialog.getFirstResult()).getName() : filteredAvailableRoute.getFirst().getName();
        return result;
    }

    private LinkedList<Route> filterAvailableRoute(List<Route> availableRoutes) {
        Map<String, Route> routeNameAndRoute = this.getRouteNameAndRoute(availableRoutes);
        for (Object view : DiagramEditPartsUtil.getEObjectViews((EObject)this.getProperty())) {
            String routeNamedSaved;
            if (!(view instanceof Node) || !routeNameAndRoute.containsKey(routeNamedSaved = this.getRootingProperty((Node)view))) continue;
            routeNameAndRoute.remove(routeNamedSaved);
        }
        return new LinkedList<Route>(routeNameAndRoute.values());
    }

    private Map<String, Route> getRouteNameAndRoute(List<Route> routes) {
        HashMap<String, Route> routeAndName = new HashMap<String, Route>();
        for (Route route : routes) {
            routeAndName.put(route.getName(), route);
        }
        return routeAndName;
    }

    private String calculateNewRoute(String oldRouteSelectedValue) {
        LinkedList<String> availableSpecificRoute = new LinkedList<String>();
        if (this.getAvailableRoutes().get(0).getName().length() > oldRouteSelectedValue.length()) {
            for (Route route : this.getAvailableRoutes()) {
                if (route.getName().indexOf(oldRouteSelectedValue) <= 0) continue;
                availableSpecificRoute.add(route.getName());
            }
            if (availableSpecificRoute.size() == 1) {
                return (String)availableSpecificRoute.get(0);
            }
        } else {
            for (Route route : this.getAvailableRoutes()) {
                if (oldRouteSelectedValue.indexOf(route.getName()) <= 0) continue;
                availableSpecificRoute.add(route.getName());
            }
            if (availableSpecificRoute.size() == 1) {
                return (String)availableSpecificRoute.get(0);
            }
        }
        return "";
    }

    public void createRootingProperty(Node node, String name) {
        if ("".equals(this.getRootingProperty(node))) {
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(PROPERTY_ROUTE_URL_SOURCE);
            node.getEAnnotations().add((Object)annotation);
            annotation.getDetails().put((Object)SELECTED_ROUTE_KEY, (Object)name);
        }
    }

    public boolean isExistingRoute(String name) {
        boolean result = false;
        for (Route r : this.getAvailableRoutes()) {
            result |= r.getName().equals(name);
        }
        return result;
    }

    private String getRootingProperty(Node node) {
        String value = "";
        EAnnotation eAnnotation = node.getEAnnotation(PROPERTY_ROUTE_URL_SOURCE);
        if (eAnnotation != null) {
            value = (String)eAnnotation.getDetails().get((Object)SELECTED_ROUTE_KEY);
        }
        return value;
    }
}

