/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.utils;

import java.util.LinkedList;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route {
    private LinkedList<Property> propertyList;
    private String name;

    public Route() {
        this(new LinkedList<Property>());
    }

    public Route(LinkedList<Property> propertyList) {
        assert (propertyList != null);
        this.propertyList = propertyList;
        this.name = "";
    }

    protected void addSegment(Property property) {
        this.propertyList.add(property);
    }

    private void calculateName() {
        this.name = "";
        for (Property property : this.propertyList) {
            this.name = this.name.length() == 0 ? property.getName() : String.valueOf(this.name) + "." + property.getName();
        }
    }

    public String getName() {
        this.calculateName();
        return this.name;
    }

    public LinkedList<Property> getProperties() {
        return this.propertyList;
    }

    public int getRouteDepth() {
        return this.propertyList.size();
    }
}

